/*
 * Decompiled with CFR 0.152.
 */
package me.branchpanic.mods.stockpile.content.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.branchpanic.mods.stockpile.content.blockentity.ItemBarrelBlockEntity;
import me.branchpanic.mods.stockpile.content.client.renderer.ItemBarrelRenderer$WhenMappings;
import me.branchpanic.mods.stockpile.content.client.renderer.ItemBarrelRendererKt;
import me.branchpanic.mods.stockpile.impl.storage.MassItemStorage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J:\u0010\u0013\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J0\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J \u0010\u001f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0002J(\u0010\"\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lme/branchpanic/mods/stockpile/content/client/renderer/ItemBarrelRenderer;", "Lnet/minecraft/client/render/block/entity/BlockEntityRenderer;", "Lme/branchpanic/mods/stockpile/content/blockentity/ItemBarrelBlockEntity;", "()V", "COFH_TRANSFORM_OFFSET", "", "FILL_BAR_WIDTH", "drawRectangle", "", "x1", "y1", "x2", "y2", "color", "Ljava/awt/Color;", "getDisplayText", "", "storage", "Lme/branchpanic/mods/stockpile/impl/storage/MassItemStorage;", "render", "barrel", "x", "y", "z", "partialTicks", "", "breakStage", "", "renderDisplay", "orientation", "Lnet/minecraft/util/math/Direction;", "renderFillBar", "xCenter", "yCenter", "transformToFace", "stockpile"})
@Environment(value=EnvType.CLIENT)
public final class ItemBarrelRenderer
extends class_827<ItemBarrelBlockEntity> {
    private static final double FILL_BAR_WIDTH = 18.0;
    private static final double COFH_TRANSFORM_OFFSET = 0.001953125;
    public static final ItemBarrelRenderer INSTANCE;

    public void render(@Nullable ItemBarrelBlockEntity barrel, double x, double y, double z, float partialTicks, int breakStage) {
        super.method_3569((class_2586)barrel, x, y, z, partialTicks, breakStage);
        if (barrel == null) {
            return;
        }
        class_2350 face = (class_2350)barrel.method_11010().method_11654((class_2769)class_2741.field_12525);
        class_2338 obscuringPos = barrel.method_11016().method_10093(face);
        if (this.method_3565().method_8320(obscuringPos).method_11598((class_1922)this.method_3565(), obscuringPos) || barrel.getBackingStorage().getCurrentInstance().method_7960()) {
            return;
        }
        MassItemStorage massItemStorage = barrel.getBackingStorage();
        class_2350 class_23502 = face;
        Intrinsics.checkExpressionValueIsNotNull((Object)class_23502, (String)"face");
        this.renderDisplay(massItemStorage, class_23502, x, y, z);
    }

    private final void transformToFace(class_2350 orientation, double x, double y, double z) {
        switch (ItemBarrelRenderer$WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1: {
                GlStateManager.translated((double)(x + 0.75), (double)(y + 0.75), (double)(z + 0.283203125));
                break;
            }
            case 2: {
                GlStateManager.translated((double)(x + 0.25), (double)(y + 0.75), (double)(z + 1.0 - 0.283203125));
                GlStateManager.rotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 3: {
                GlStateManager.translated((double)(x + 0.283203125), (double)(y + 0.75), (double)(z + 0.25));
                GlStateManager.rotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 4: {
                GlStateManager.translated((double)(x + 1.0 - 0.283203125), (double)(y + 0.75), (double)(z + 0.75));
                GlStateManager.rotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 5: {
                GlStateManager.translated((double)(x + 0.75), (double)(y + 1.0 - 0.283203125), (double)(z + 0.75));
                GlStateManager.rotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case 6: {
                GlStateManager.translated((double)(x + 0.75), (double)(y + 0.283203125), (double)(z + 0.25));
                GlStateManager.rotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
            }
        }
    }

    private final void renderFillBar(MassItemStorage storage, double xCenter, double yCenter) {
        GlStateManager.translated((double)0.0, (double)0.0, (double)153.6);
        GlStateManager.scaled((double)0.5, (double)0.5, (double)1.0);
        String displayText = this.getDisplayText(storage);
        long amount = storage.getAmountStored();
        long capacity = storage.getCapacity();
        double filledAmount = (double)amount / (double)capacity;
        int textColor = capacity > amount ? 0xFFFFFF : 0xFFFF22;
        int textWidth = this.method_3564().method_1727(displayText);
        int textHeight = this.method_3564().field_2000;
        double textCenterX = xCenter * (double)2 - (double)(textWidth / 2);
        double textCenterY = yCenter * (double)2 - (double)(textHeight / 2);
        double totalBarWidth = 40.5;
        double filledBarWidth = totalBarWidth * Math.min(filledAmount, 1.0);
        double unfilledBarWidth = totalBarWidth - filledBarWidth;
        GlStateManager.disableTexture();
        if (filledBarWidth > 0.0) {
            this.drawRectangle(-4.5, textCenterY + (double)textHeight, filledBarWidth - 4.5, textCenterY - 0.25 * (double)textHeight, new Color(0.0f, 0.0f, 1.0f, 0.7f));
        }
        if (unfilledBarWidth > 0.0) {
            this.drawRectangle(filledBarWidth - 4.5, textCenterY + (double)textHeight, filledBarWidth + unfilledBarWidth - 4.5, textCenterY - 0.25 * (double)textHeight, new Color(0.0f, 0.0f, 0.0f, 0.7f));
        }
        GlStateManager.enableTexture();
        GlStateManager.translated((double)0.0, (double)0.0, (double)0.02);
        this.method_3564().method_1729(displayText, (float)textCenterX, (float)textCenterY, textColor);
    }

    private final void drawRectangle(double x1, double y1, double x2, double y2, Color color) {
        class_289 tessellator;
        class_289 class_2892 = tessellator = class_289.method_1348();
        Intrinsics.checkExpressionValueIsNotNull((Object)class_2892, (String)"tessellator");
        class_287 bufferBuilder = class_2892.method_1349();
        bufferBuilder.method_1328(7, class_290.field_1576);
        bufferBuilder.method_1315(x2, y1, 0.0).method_1323(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
        bufferBuilder.method_1315(x2, y2, 0.0).method_1323(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
        bufferBuilder.method_1315(x1, y2, 0.0).method_1323(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
        bufferBuilder.method_1315(x1, y1, 0.0).method_1323(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
        tessellator.method_1350();
    }

    private final void renderDisplay(MassItemStorage storage, class_2350 orientation, double x, double y, double z) {
        class_1799 stack = storage.getCurrentInstance();
        GlStateManager.enableRescaleNormal();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.enableBlend();
        class_308.method_1452();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.pushMatrix();
        this.transformToFace(orientation, x, y, z);
        GlStateManager.scaled((double)0.03125, (double)0.03125, (double)-0.001953125);
        GlStateManager.rotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        GlStateManager.translated((double)0.0, (double)0.0, (double)6.0);
        class_310 class_3102 = class_310.method_1551();
        Intrinsics.checkExpressionValueIsNotNull((Object)class_3102, (String)"MinecraftClient.getInstance()");
        class_3102.method_1480().method_4023(stack, 0, -3);
        GlStateManager.translated((double)0.0, (double)0.0, (double)-6.0);
        this.renderFillBar(storage, 8.0, 16.0);
        GlStateManager.popMatrix();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableBlend();
    }

    private final String getDisplayText(MassItemStorage storage) {
        String string;
        if (storage.isEmpty()) {
            String string2 = class_1074.method_4662((String)"ui.stockpile.empty", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"I18n.translate(\"ui.stockpile.empty\")");
        } else {
            string = ItemBarrelRendererKt.abbreviate(storage.getAmountStored()) + (storage.getClearWhenEmpty() ? "*" : "");
        }
        return string;
    }

    private ItemBarrelRenderer() {
    }

    static {
        ItemBarrelRenderer itemBarrelRenderer;
        INSTANCE = itemBarrelRenderer = new ItemBarrelRenderer();
    }
}

