/*
 * Decompiled with CFR 0.152.
 */
package me.branchpanic.mods.stockpile.impl.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.LongIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import me.branchpanic.mods.stockpile.ItemstacksKt;
import me.branchpanic.mods.stockpile.api.storage.MassStorage;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\tH\u0016J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0016J$\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020'2\u0006\u0010\"\u001a\u00020\tH\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\tH\u0016J\u0018\u0010)\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\tH\u0016J\b\u0010*\u001a\u00020$H\u0016J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020'2\u0006\u0010,\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\tH\u0016R\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u001d\u00a8\u0006-"}, d2={"Lme/branchpanic/mods/stockpile/impl/storage/MassItemStorage;", "Lme/branchpanic/mods/stockpile/api/storage/MassStorage;", "Lnet/minecraft/item/ItemStack;", "maxStacks", "", "storedItems", "", "storedStack", "clearWhenEmpty", "", "(IJLnet/minecraft/item/ItemStack;Z)V", "amountStored", "getAmountStored", "()J", "capacity", "getCapacity", "getClearWhenEmpty", "()Z", "setClearWhenEmpty", "(Z)V", "currentInstance", "getCurrentInstance", "()Lnet/minecraft/item/ItemStack;", "instanceIsSet", "getInstanceIsSet", "getMaxStacks", "()I", "getStoredStack", "setStoredStack", "(Lnet/minecraft/item/ItemStack;)V", "accepts", "t", "add", "count", "simulate", "clear", "", "clearInstanceWhenEmpty", "offer", "", "ts", "remove", "retainInstanceWhenEmpty", "take", "amount", "stockpile"})
public final class MassItemStorage
implements MassStorage<class_1799> {
    private final int maxStacks;
    private long storedItems;
    @NotNull
    private class_1799 storedStack;
    private boolean clearWhenEmpty;

    @Override
    public long getAmountStored() {
        return this.storedItems;
    }

    @Override
    public long getCapacity() {
        return this.getCurrentInstance().method_7914() * this.maxStacks;
    }

    @Override
    @NotNull
    public class_1799 getCurrentInstance() {
        return this.storedStack;
    }

    @Override
    public boolean getInstanceIsSet() {
        return !this.getCurrentInstance().method_7960();
    }

    private final void clear() {
        this.storedItems = 0L;
        class_1799 class_17992 = class_1799.field_8037;
        Intrinsics.checkExpressionValueIsNotNull((Object)class_17992, (String)"ItemStack.EMPTY");
        this.storedStack = class_17992;
    }

    @Override
    public void clearInstanceWhenEmpty() {
        this.clearWhenEmpty = true;
        if (this.isEmpty()) {
            this.clear();
        }
    }

    @Override
    public void retainInstanceWhenEmpty() {
        this.clearWhenEmpty = false;
    }

    @Override
    public boolean accepts(@NotNull class_1799 t) {
        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
        return this.storedStack.method_7960() || ItemstacksKt.isStackableWith(t, this.storedStack);
    }

    @Override
    public long add(long count, boolean simulate) {
        long newAmount = this.storedItems + count;
        if (newAmount > this.getCapacity()) {
            if (!simulate) {
                this.storedItems = this.getCapacity();
            }
            return newAmount - this.getCapacity();
        }
        if (!simulate) {
            this.storedItems = newAmount;
        }
        return 0L;
    }

    @Override
    public long remove(long count, boolean simulate) {
        long l;
        if (count >= this.storedItems) {
            long countRemoved = this.storedItems;
            if (!simulate) {
                this.storedItems = 0L;
                if (this.clearWhenEmpty) {
                    this.clear();
                }
            }
            l = countRemoved;
        } else {
            if (!simulate) {
                this.storedItems -= count;
            }
            l = count;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<class_1799> offer(@NotNull List<class_1799> ts, boolean simulate) {
        void $this$filterNotTo$iv$iv;
        class_1799 t;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(ts, (String)"ts");
        Iterable $this$map$iv = ts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            class_1799 class_17992 = (class_1799)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            class_1799 class_17993 = this.offer(t, simulate);
            collection.add(class_17993);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            t = (class_1799)element$iv$iv;
            boolean bl = false;
            if (t.method_7960()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public class_1799 offer(@NotNull class_1799 t, boolean simulate) {
        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
        if (t.method_7960() || !this.accepts(t)) {
            return t;
        }
        if (!simulate && !this.getInstanceIsSet()) {
            this.storedStack = ItemstacksKt.withCount(t, 1);
        }
        int remainder = (int)this.add(t.method_7947(), simulate);
        return ItemstacksKt.withCount(t, remainder);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<class_1799> take(long amount, boolean simulate) {
        void $this$filterNotTo$iv$iv;
        void $this$mapTo$iv$iv;
        if (amount == 0L || this.storedStack.method_7960() || this.getAmountStored() == 0L) {
            return CollectionsKt.emptyList();
        }
        class_1799 lastStoredStack = this.storedStack;
        long removableAmount = this.remove(amount, simulate);
        long removableFullStacks = removableAmount / (long)lastStoredStack.method_7914();
        long removableRemainingStack = removableAmount - (long)lastStoredStack.method_7914() * removableFullStacks;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (long)removableFullStacks);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            long item$iv$iv;
            long l = item$iv$iv = ((LongIterator)iterator).nextLong();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            class_1799 class_17992 = ItemstacksKt.withCount(lastStoredStack, lastStoredStack.method_7914());
            collection.add(class_17992);
        }
        List fullStacks = (List)destination$iv$iv;
        class_1799 remainderStack = ItemstacksKt.withCount(lastStoredStack, (int)removableRemainingStack);
        Iterable $this$filterNot$iv = CollectionsKt.plus((Collection)fullStacks, (Object)remainderStack);
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            class_1799 s = (class_1799)element$iv$iv;
            boolean bl = false;
            if (s.method_7960()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    public final int getMaxStacks() {
        return this.maxStacks;
    }

    @NotNull
    public final class_1799 getStoredStack() {
        return this.storedStack;
    }

    public final void setStoredStack(@NotNull class_1799 class_17992) {
        Intrinsics.checkParameterIsNotNull((Object)class_17992, (String)"<set-?>");
        this.storedStack = class_17992;
    }

    public final boolean getClearWhenEmpty() {
        return this.clearWhenEmpty;
    }

    public final void setClearWhenEmpty(boolean bl) {
        this.clearWhenEmpty = bl;
    }

    public MassItemStorage(int maxStacks, long storedItems, @NotNull class_1799 storedStack, boolean clearWhenEmpty) {
        Intrinsics.checkParameterIsNotNull((Object)storedStack, (String)"storedStack");
        this.maxStacks = maxStacks;
        this.storedItems = storedItems;
        this.storedStack = storedStack;
        this.clearWhenEmpty = clearWhenEmpty;
    }

    public /* synthetic */ MassItemStorage(int n, long l, class_1799 class_17992, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            l = 0L;
        }
        if ((n2 & 4) != 0) {
            class_1799 class_17993 = class_1799.field_8037;
            Intrinsics.checkExpressionValueIsNotNull((Object)class_17993, (String)"ItemStack.EMPTY");
            class_17992 = class_17993;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        this(n, l, class_17992, bl);
    }

    @Override
    public boolean isEmpty() {
        return MassStorage.DefaultImpls.isEmpty(this);
    }

    @Override
    public boolean isFull() {
        return MassStorage.DefaultImpls.isFull(this);
    }
}

