/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.nightlights.block;

import com.flechazo.nightlights.block.AbstractLightBlock;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CeilingLightBlock
extends AbstractLightBlock {
    public static final EnumProperty<Direction> FACING = EnumProperty.create((String)"facing", Direction.class, (Enum[])new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST});
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)0.0, (double)5.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), (Object)Direction.WEST, (Object)Block.box((double)15.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)5.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0)));

    public CeilingLightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)BRIGHTNESS, (Comparable)Integer.valueOf(this.getDefaultBrightness()))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue(FACING));
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos above = pos.above();
        return CeilingLightBlock.canSupportRigidBlock((BlockGetter)level, (BlockPos)above) || CeilingLightBlock.canSupportCenter((LevelReader)level, (BlockPos)above, (Direction)Direction.DOWN) && !level.isEmptyBlock(above);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)BRIGHTNESS, (Comparable)Integer.valueOf(this.getDefaultBrightness()))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true));
    }

    @Override
    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        return !state.canSurvive(level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, BRIGHTNESS, LIT});
    }

    @Override
    protected int getDefaultBrightness() {
        return 10;
    }

    @Override
    protected boolean isAdjustable() {
        return super.isAdjustable();
    }
}

