import os
import json

def add_render_type_to_json(folder_path):
    for root, dirs, files in os.walk(folder_path):
        for file in files:
            if file.endswith('.json'):
                file_path = os.path.join(root, file)
                try:
                    with open(file_path, 'r', encoding='utf-8') as f:
                        data = json.load(f)

                    # 插入 "render_type": "cutout" 在 "credit" 之后
                    if "credit" in data and "render_type" not in data:
                        # 使用 OrderedDict 来保持顺序
                        from collections import OrderedDict
                        new_data = OrderedDict()
                        for k, v in data.items():
                            new_data[k] = v
                            if k == "credit":
                                new_data["render_type"] = "cutout"

                        with open(file_path, 'w', encoding='utf-8') as f:
                            json.dump(new_data, f, indent=2, ensure_ascii=False)

                        print(f"Updated: {file_path}")
                except Exception as e:
                    print(f"Failed to process {file_path}: {e}")

# 使用方法：替换为你的路径
add_render_type_to_json(r"F:\code\mcmod\project\night-lights\src\main\resources\assets\nightlights\models\block")
