/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.nightlights.block;

import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLightBlock
extends class_2248 {
    public static final class_2758 BRIGHTNESS = class_2758.method_11867((String)"brightness", (int)0, (int)15);
    public static final class_2746 LIT = class_2746.method_11825((String)"lit");

    protected AbstractLightBlock(class_4970.class_2251 properties) {
        super(properties.method_9631(state -> (Boolean)state.method_11654((class_2769)LIT) != false ? (Integer)state.method_11654((class_2769)BRIGHTNESS) : 0));
    }

    @NotNull
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        if (!level.method_8608()) {
            if (this.isAdjustable()) {
                this.handleLightInteraction(state, level, pos);
            } else {
                this.handleFixedLightInteraction(state, level, pos);
            }
        }
        return class_1269.field_5812;
    }

    protected void handleLightInteraction(class_2680 state, class_1937 level, class_2338 pos) {
        boolean isLit = (Boolean)state.method_11654((class_2769)LIT);
        int currentBrightness = (Integer)state.method_11654((class_2769)BRIGHTNESS);
        int[] levels = this.getBrightnessLevels();
        if (!isLit || currentBrightness == 0) {
            class_2680 newState = (class_2680)((class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)BRIGHTNESS, (Comparable)Integer.valueOf(levels[1]));
            level.method_8652(pos, newState, 3);
            this.playLightSound(level, pos, true, levels[1]);
        } else {
            int nextIndex;
            int nextBrightness;
            int currentIndex = -1;
            for (int i = 0; i < levels.length; ++i) {
                if (levels[i] != currentBrightness) continue;
                currentIndex = i;
                break;
            }
            if ((nextBrightness = levels[nextIndex = (currentIndex + 1) % levels.length]) == 0) {
                class_2680 newState = (class_2680)((class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)BRIGHTNESS, (Comparable)Integer.valueOf(this.getDefaultBrightness()));
                level.method_8652(pos, newState, 3);
                this.playLightSound(level, pos, false, 0);
            } else {
                class_2680 newState = (class_2680)state.method_11657((class_2769)BRIGHTNESS, (Comparable)Integer.valueOf(nextBrightness));
                level.method_8652(pos, newState, 3);
                this.playLightSound(level, pos, true, nextBrightness);
            }
        }
    }

    protected void handleFixedLightInteraction(class_2680 state, class_1937 level, class_2338 pos) {
        boolean isLit = (Boolean)state.method_11654((class_2769)LIT);
        if (isLit) {
            class_2680 newState = (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false));
            level.method_8652(pos, newState, 3);
            this.playLightSound(level, pos, false, 0);
        } else {
            class_2680 newState = (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(true));
            level.method_8652(pos, newState, 3);
            this.playLightSound(level, pos, true, this.getDefaultBrightness());
        }
    }

    protected void playLightSound(class_1937 level, class_2338 pos, boolean turnOn, int brightness) {
        if (turnOn) {
            float pitch = 0.5f + (float)brightness * 0.03f;
            level.method_8396(null, pos, class_3417.field_14791, class_3419.field_15245, 0.6f, pitch);
        } else {
            level.method_8396(null, pos, class_3417.field_14954, class_3419.field_15245, 0.6f, 0.5f);
        }
    }

    protected abstract int getDefaultBrightness();

    protected boolean isAdjustable() {
        return false;
    }

    protected int[] getBrightnessLevels() {
        return new int[]{0, this.getDefaultBrightness()};
    }
}

