/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelertoolbelt.TravelerToolBelt;
import com.tiviacz.travelertoolbelt.config.TravelerToolBeltConfig;
import com.tiviacz.travelertoolbelt.item.ToolBeltItem;
import com.tiviacz.travelertoolbelt.toolbelt.ToolBeltWrapper;
import com.tiviacz.travelertoolbelt.util.InventoryHelper;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class ToolBeltHelper {
    public static Optional<Pair<ItemStack, Integer>> getEquippedToolBelt(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (TravelerToolBelt.curiosLoaded) {
                AtomicReference<ItemStack> toolbelt = new AtomicReference<ItemStack>(ItemStack.EMPTY);
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curios -> {
                    if (curios.isEquipped(p -> p.getItem() instanceof ToolBeltItem)) {
                        toolbelt.set(curios.findFirstCurio(t -> t.getItem() instanceof ToolBeltItem).map(SlotResult::stack).orElse(ItemStack.EMPTY));
                    }
                });
                return toolbelt.get().isEmpty() ? Optional.empty() : Optional.of(Pair.of((Object)toolbelt.get(), (Object)-1));
            }
            if (TravelerToolBelt.accessoriesLoaded) {
                AtomicReference<ItemStack> toolbelt = new AtomicReference<ItemStack>(ItemStack.EMPTY);
                AccessoriesCapability.getOptionally((LivingEntity)player).ifPresent(accessories -> {
                    if (accessories.isEquipped(p -> p.getItem() instanceof ToolBeltItem)) {
                        toolbelt.set(accessories.getFirstEquipped(p -> p.getItem() instanceof ToolBeltItem).stack());
                    }
                });
                return toolbelt.get().isEmpty() ? Optional.empty() : Optional.of(Pair.of((Object)toolbelt.get(), (Object)-1));
            }
            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                ItemStack stack = (ItemStack)player.getInventory().items.get(i);
                if (!(stack.getItem() instanceof ToolBeltItem)) continue;
                return Optional.of(Pair.of((Object)stack, (Object)i));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> getEquippedToolBeltForRendering(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (TravelerToolBelt.curiosLoaded) {
                AtomicReference<ItemStack> toolbelt = new AtomicReference<ItemStack>(ItemStack.EMPTY);
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curios -> {
                    if (curios.isEquipped(p -> p.getItem() instanceof ToolBeltItem)) {
                        toolbelt.set(curios.findFirstCurio(t -> t.getItem() instanceof ToolBeltItem).map(slotResult -> slotResult.slotContext().visible() ? slotResult.stack() : ItemStack.EMPTY).orElse(ItemStack.EMPTY));
                    }
                });
                return toolbelt.get().isEmpty() ? Optional.empty() : Optional.of(toolbelt.get());
            }
            if (TravelerToolBelt.accessoriesLoaded) {
                AtomicReference<ItemStack> toolbelt = new AtomicReference<ItemStack>(ItemStack.EMPTY);
                AccessoriesCapability.getOptionally((LivingEntity)player).ifPresent(accessories -> {
                    if (accessories.isEquipped(p -> p.getItem() instanceof ToolBeltItem)) {
                        SlotEntryReference context = accessories.getFirstEquipped(p -> p.getItem() instanceof ToolBeltItem);
                        boolean visible = context.reference().slotContainer().shouldRender(context.reference().slot());
                        toolbelt.set(visible ? context.stack() : ItemStack.EMPTY);
                    }
                });
                return toolbelt.get().isEmpty() ? Optional.empty() : Optional.of(toolbelt.get());
            }
            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                ItemStack stack = (ItemStack)player.getInventory().items.get(i);
                if (!(stack.getItem() instanceof ToolBeltItem)) continue;
                return Optional.of(stack);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static Optional<ToolBeltWrapper> getEquippedToolBeltWrapper(Player player) {
        return ToolBeltHelper.getEquippedToolBelt((LivingEntity)player).map(p -> ToolBeltWrapper.fromStack((ItemStack)p.getFirst()));
    }

    public static boolean isItemValid(ItemStack stack) {
        Item item = stack.getItem();
        if (stack.isEmpty()) {
            return false;
        }
        if (TravelerToolBeltConfig.whitelist.stream().anyMatch(i -> i == item)) {
            return true;
        }
        if (TravelerToolBeltConfig.blacklist.stream().anyMatch(i -> i == item)) {
            return false;
        }
        if (stack.getItem() instanceof ToolBeltItem) {
            return false;
        }
        return (Boolean)TravelerToolBeltConfig.SERVER.allowAllNonStackableItems.get() != false && stack.getMaxStackSize() == 1 || (Boolean)TravelerToolBeltConfig.SERVER.allowAllItems.get() != false;
    }

    public static void swapTool(Player player, int slot) {
        ToolBeltHelper.getEquippedToolBelt((LivingEntity)player).ifPresent(pair -> {
            ItemStack handStack = player.getMainHandItem().copy();
            if (!ToolBeltHelper.isItemValid(handStack) && !handStack.isEmpty()) {
                return;
            }
            ToolBeltWrapper wrapper = ToolBeltWrapper.fromStack((ItemStack)pair.getFirst());
            ItemStackHandler inv = wrapper.getBeltContents();
            if (slot == -999) {
                ItemStack stack = InventoryHelper.addItemStackToHandler(inv, handStack, false);
                if (stack.isEmpty()) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                }
            } else {
                ItemStack currentTool = inv.getStackInSlot(slot).copy();
                player.setItemInHand(InteractionHand.MAIN_HAND, currentTool);
                inv.setStackInSlot(slot, handStack);
            }
            player.level().playSound(null, player.position().x(), player.position().y() + 0.5, player.position().z(), SoundEvents.ARMOR_EQUIP_LEATHER, SoundSource.BLOCKS, 1.0f, 1.0f);
        });
    }
}

