/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt;

import com.tiviacz.travelertoolbelt.compat.BeltAccessory;
import com.tiviacz.travelertoolbelt.compat.BeltAccessoryRenderer;
import com.tiviacz.travelertoolbelt.compat.BeltCurioIntegration;
import com.tiviacz.travelertoolbelt.config.TravelerToolBeltConfig;
import com.tiviacz.travelertoolbelt.init.ModItems;
import com.tiviacz.travelertoolbelt.init.ModRecipeSerializers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="travelertoolbelt")
public class TravelerToolBelt {
    public static final String MODID = "travelertoolbelt";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean curiosLoaded;
    public static boolean accessoriesLoaded;

    public TravelerToolBelt(IEventBus eventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)TravelerToolBeltConfig.serverSpec);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)TravelerToolBeltConfig.clientSpec);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        eventBus.addListener(this::setup);
        eventBus.addListener(this::doClientStuff);
        ModItems.ITEMS.register(eventBus);
        ModRecipeSerializers.SERIALIZERS.register(eventBus);
        curiosLoaded = ModList.get().isLoaded("curios");
        accessoriesLoaded = ModList.get().isLoaded("accessories");
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            if (curiosLoaded) {
                BeltCurioIntegration.register();
            }
            if (accessoriesLoaded) {
                BeltAccessory.register();
            }
        });
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            if (accessoriesLoaded) {
                BeltAccessoryRenderer.register();
            }
        });
    }
}

