/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tiviacz.travelertoolbelt.ToolBeltHelper;
import com.tiviacz.travelertoolbelt.client.model.BeltModel;
import com.tiviacz.travelertoolbelt.handlers.ModClientEventHandler;
import com.tiviacz.travelertoolbelt.item.ToolBeltItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;

public class BeltLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public static final ResourceLocation LEATHER_BELT = ResourceLocation.fromNamespaceAndPath((String)"travelertoolbelt", (String)"textures/entity/belt.png");
    public static final ResourceLocation COPPER_BELT = ResourceLocation.fromNamespaceAndPath((String)"travelertoolbelt", (String)"textures/entity/copper_belt.png");
    public static final ResourceLocation IRON_BELT = ResourceLocation.fromNamespaceAndPath((String)"travelertoolbelt", (String)"textures/entity/iron_belt.png");
    public static final ResourceLocation GOLD_BELT = ResourceLocation.fromNamespaceAndPath((String)"travelertoolbelt", (String)"textures/entity/gold_belt.png");
    public static final ResourceLocation DIAMOND_BELT = ResourceLocation.fromNamespaceAndPath((String)"travelertoolbelt", (String)"textures/entity/diamond_belt.png");
    public static final ResourceLocation NETHERITE_BELT = ResourceLocation.fromNamespaceAndPath((String)"travelertoolbelt", (String)"textures/entity/netherite_belt.png");
    private final BeltModel<T> beltModel = new BeltModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModClientEventHandler.BELT_LAYER));

    public BeltLayer(RenderLayerParent<T, M> owner) {
        super(owner);
    }

    private void translateToBody(LivingEntity entity, PoseStack poseStack) {
        ((HumanoidModel)this.getParentModel()).body.translateAndRotate(poseStack);
        if (entity.isBaby() && !(entity instanceof Villager)) {
            poseStack.scale(0.52f, 0.52f, 0.52f);
            poseStack.translate(0.0, 1.4, 0.0);
        }
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int lightness, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ToolBeltHelper.getEquippedToolBeltForRendering(entity).ifPresent(belt -> {
            matrixStack.pushPose();
            this.translateToBody((LivingEntity)entity, matrixStack);
            matrixStack.scale(1.05f, 1.05f, 1.05f);
            BeltLayer.renderColoredCutoutModel(this.beltModel, (ResourceLocation)this.getTextureLocation(entity), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)lightness, (LivingEntity)entity, (int)-1);
            matrixStack.popPose();
        });
    }

    protected ResourceLocation getTextureLocation(T pEntity) {
        return ToolBeltHelper.getEquippedToolBeltForRendering(pEntity).map(belt -> ((ToolBeltItem)belt.getItem()).getModelTexture()).orElse(LEATHER_BELT);
    }
}

