/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.client.screens;

import com.mojang.blaze3d.platform.Window;
import com.tiviacz.travelertoolbelt.ToolBeltHelper;
import com.tiviacz.travelertoolbelt.client.screens.RadialOverlay;
import com.tiviacz.travelertoolbelt.config.TravelerToolBeltConfig;
import com.tiviacz.travelertoolbelt.handlers.ModClientEventHandler;
import com.tiviacz.travelertoolbelt.handlers.NeoForgeClientEventHandler;
import com.tiviacz.travelertoolbelt.item.ToolBeltItem;
import com.tiviacz.travelertoolbelt.network.ServerboundSwapToolPacket;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.network.PacketDistributor;
import org.lwjgl.glfw.GLFW;

public class BeltScreen
extends Screen {
    private static final double REF_W = 1920.0;
    private static final double REF_H = 1080.0;
    private long openStartMs = -1L;
    private final ItemStack toolbelt;

    public BeltScreen(ItemStack toolbelt) {
        super((Component)Component.translatable((String)"screen.travelertoolbelt.belt"));
        this.toolbelt = toolbelt;
    }

    private float getOpenProgress() {
        long now = System.currentTimeMillis();
        if (this.openStartMs < 0L) {
            this.openStartMs = now;
        }
        float durMs = 180.0f;
        return Mth.clamp((float)((float)(now - this.openStartMs) / durMs), (float)0.0f, (float)1.0f);
    }

    protected void init() {
        super.init();
        Window mainWindow = Minecraft.getInstance().getWindow();
        int sw = mainWindow.getScreenWidth();
        int sh = mainWindow.getScreenHeight();
        int cx = sw / 2;
        int cy = sh / 2;
        int offXpx = (Integer)TravelerToolBeltConfig.CLIENT.offsetX.get();
        int offYpx = (Integer)TravelerToolBeltConfig.CLIENT.offsetY.get();
        double px = (double)offXpx / 1920.0;
        double py = (double)offYpx / 1080.0;
        int scaledWidth = (int)Math.round((double)cx + px * (double)sw);
        int scaledHeight = (int)Math.round((double)cy + py * (double)sh);
        GLFW.glfwSetCursorPos((long)Minecraft.getInstance().getWindow().getWindow(), (double)scaledWidth, (double)scaledHeight);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean canAdd;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        Window mainWindow = mc.getWindow();
        int sw = mainWindow.getGuiScaledWidth();
        int sh = mainWindow.getGuiScaledHeight();
        int cx = sw / 2;
        int cy = sh / 2;
        int offXpx = (Integer)TravelerToolBeltConfig.CLIENT.offsetX.get();
        int offYpx = (Integer)TravelerToolBeltConfig.CLIENT.offsetY.get();
        double px = (double)offXpx / 1920.0;
        double py = (double)offYpx / 1080.0;
        int scaledWidth = (int)Math.round((double)cx + px * (double)sw);
        int scaledHeight = (int)Math.round((double)cy + py * (double)sh);
        float progress = this.getOpenProgress();
        ItemStack heldItem = player.getMainHandItem();
        int toolbeltSize = ((ToolBeltItem)this.toolbelt.getItem()).getSlotCount();
        NonNullList<ItemStack> tools = ((ItemContainerContents)this.toolbelt.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)NonNullList.withSize((int)toolbeltSize, (Object)ItemStack.EMPTY)))).stream().collect(Collectors.toCollection(NonNullList::create));
        int nonEmptyCount = BeltScreen.getNonEmptyTools(tools).size();
        boolean bl = canAdd = ToolBeltHelper.isItemValid(heldItem) && nonEmptyCount < toolbeltSize;
        if (tools.size() < toolbeltSize) {
            tools = BeltScreen.getExpandedTools(tools, toolbeltSize);
        }
        int hoveredResult = RadialOverlay.renderRadial(graphics, this.toolbelt, heldItem, tools, canAdd, scaledWidth, scaledHeight, mouseX, mouseY, partialTick, progress);
        if (!NeoForgeClientEventHandler.isKeyDown(ModClientEventHandler.OPEN_TOOLBELT)) {
            if (hoveredResult != -1) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSwapToolPacket(hoveredResult), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.onClose();
        }
    }

    public static NonNullList<ItemStack> getExpandedTools(NonNullList<ItemStack> tools, int expectedSize) {
        NonNullList expanded = NonNullList.create();
        for (int i = 0; i < expectedSize; ++i) {
            if (i < tools.size()) {
                expanded.add((Object)((ItemStack)tools.get(i)));
                continue;
            }
            expanded.add((Object)ItemStack.EMPTY);
        }
        return expanded;
    }

    public static NonNullList<ItemStack> getNonEmptyTools(NonNullList<ItemStack> inventory) {
        NonNullList tools = NonNullList.create();
        for (ItemStack itemStack : inventory) {
            if (itemStack.isEmpty()) continue;
            tools.add((Object)itemStack);
        }
        return tools;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

