/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.client.screens.tooltip;

import com.tiviacz.travelertoolbelt.client.screens.tooltip.BeltTooltipComponent;
import com.tiviacz.travelertoolbelt.handlers.NeoForgeClientEventHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class ClientBeltTooltipComponent
implements ClientTooltipComponent {
    private final BeltTooltipComponent tooltipComponent;

    public ClientBeltTooltipComponent(BeltTooltipComponent tooltipComponent) {
        this.tooltipComponent = tooltipComponent;
    }

    public boolean show() {
        return NeoForgeClientEventHandler.isShiftPressed();
    }

    public int getHeight() {
        if (this.show()) {
            return !this.tooltipComponent.contents().isEmpty() ? 20 : 0;
        }
        return 0;
    }

    public int getWidth(Font font) {
        if (this.show()) {
            return this.tooltipComponent.contents().size() * 18;
        }
        return 0;
    }

    public void renderText(Font pFont, int pMouseX, int pMouseY, Matrix4f pMatrix, MultiBufferSource.BufferSource pBufferSource) {
    }

    public void renderImage(Font pFont, int pX, int pY, GuiGraphics pGuiGraphics) {
        if (!this.show()) {
            return;
        }
        for (int i = 0; i < this.tooltipComponent.contents().size(); ++i) {
            this.renderItem(this.tooltipComponent.contents().get(i), pX + i * 18, pY, pFont, pGuiGraphics);
        }
    }

    private void renderItem(ItemStack stack, int pX, int pY, Font pFont, GuiGraphics guiGraphics) {
        guiGraphics.renderFakeItem(stack, pX, pY);
        guiGraphics.renderItemDecorations(pFont, stack, pX, pY);
    }
}

