/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.config;

import com.google.common.collect.Sets;
import com.tiviacz.travelertoolbelt.TravelerToolBelt;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class TravelerToolBeltConfig {
    public static Set<Item> whitelist = Sets.newHashSet();
    public static Set<Item> blacklist = Sets.newHashSet();
    public static final ModConfigSpec serverSpec;
    public static final ModConfigSpec clientSpec;
    public static final Server SERVER;
    public static final Client CLIENT;

    public static void reload() {
        whitelist.clear();
        TravelerToolBeltConfig.loadItemsFromConfig("whitelist", (List)TravelerToolBeltConfig.SERVER.whitelist.get(), whitelist);
        blacklist.clear();
        TravelerToolBeltConfig.loadItemsFromConfig("blacklist", (List)TravelerToolBeltConfig.SERVER.blacklist.get(), blacklist);
    }

    public static void loadItemsFromConfig(String debugName, List<? extends String> configList, Set<Item> targetList) {
        for (String string : configList) {
            ResourceLocation res = ResourceLocation.tryParse((String)string);
            if (BuiltInRegistries.ITEM.containsKey(res)) {
                targetList.add((Item)BuiltInRegistries.ITEM.get(res));
                continue;
            }
            TravelerToolBelt.LOGGER.warn("Invalid registry name in Traveler Tool Belt " + debugName + " config: " + string);
        }
    }

    static {
        Pair serverPair = new ModConfigSpec.Builder().configure(Server::new);
        serverSpec = (ModConfigSpec)serverPair.getRight();
        SERVER = (Server)serverPair.getLeft();
        Pair clientPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)clientPair.getRight();
        CLIENT = (Client)clientPair.getLeft();
    }

    public static class Server {
        private static final String REGISTRY_NAME_MATCHER = "([a-z0-9_.-]+:[a-z0-9_/.-]+)";
        public final ModConfigSpec.ConfigValue<List<? extends String>> whitelist;
        public final ModConfigSpec.ConfigValue<List<? extends String>> blacklist;
        public final ModConfigSpec.BooleanValue allowAllNonStackableItems;
        public final ModConfigSpec.BooleanValue allowAllItems;

        private Server(ModConfigSpec.Builder builder) {
            builder.comment("Server config settings").push("server");
            this.whitelist = builder.worldRestart().comment("List of items allowed in the tool belt (this overrides the blacklist) (Use registry names, for example: \"minecraft:apple\", \"minecraft:flint\")").defineList("whitelist", Collections::emptyList, mapping -> ((String)mapping).matches(REGISTRY_NAME_MATCHER));
            this.blacklist = builder.worldRestart().comment("List of items not allowed in the tool belt (the whitelist takes precedence) (Use registry names, for example: \"minecraft:apple\", \"minecraft:flint\")").defineList("blacklist", Collections::emptyList, mapping -> ((String)mapping).matches(REGISTRY_NAME_MATCHER));
            this.allowAllNonStackableItems = builder.comment("If true, all non-stackable items can be placed in the tool belt").define("allowAllNonStackableItems", true);
            this.allowAllItems = builder.comment("If true, any item can be placed in the tool belt").define("allowAllItems", false);
            builder.pop();
        }
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue showTooltip;
        public final ModConfigSpec.IntValue offsetX;
        public final ModConfigSpec.IntValue offsetY;

        private Client(ModConfigSpec.Builder builder) {
            builder.comment("Client-only settings").push("client");
            this.showTooltip = builder.comment("Displays the full tooltip when hovering over an item in the tool belt. If false, only the item name is shown").define("showTooltip", false);
            this.offsetX = builder.comment("Overlay X offset (positive value moves right, negative moves left)").defineInRange("offsetX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.offsetY = builder.comment("Overlay Y offset (positive value moves down, negative moves up)").defineInRange("offsetY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

