/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.handlers;

import com.mojang.blaze3d.platform.InputConstants;
import com.tiviacz.travelertoolbelt.client.model.BeltLayer;
import com.tiviacz.travelertoolbelt.client.model.BeltModel;
import com.tiviacz.travelertoolbelt.client.screens.tooltip.BeltTooltipComponent;
import com.tiviacz.travelertoolbelt.client.screens.tooltip.ClientBeltTooltipComponent;
import com.tiviacz.travelertoolbelt.init.ModItems;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

@EventBusSubscriber(modid="travelertoolbelt", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ModClientEventHandler {
    private static final String CATEGORY = "key.travelertoolbelt.category";
    public static final KeyMapping OPEN_TOOLBELT = new KeyMapping("key.travelertoolbelt.open_toolbelt", InputConstants.Type.KEYSYM, 82, "key.travelertoolbelt.category");
    public static ModelLayerLocation BELT_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"travelertoolbelt", (String)"belt"), "main");

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(OPEN_TOOLBELT);
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BELT_LAYER, BeltModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(BeltTooltipComponent.class, ClientBeltTooltipComponent::new);
    }

    @SubscribeEvent
    public static void addItemsToCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(ModItems.BELT);
            event.accept(ModItems.COPPER_BELT);
            event.accept(ModItems.IRON_BELT);
            event.accept(ModItems.GOLD_BELT);
            event.accept(ModItems.DIAMOND_BELT);
            event.accept(ModItems.NETHERITE_BELT);
        }
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers evt) {
        ModClientEventHandler.addPlayerLayer(evt, PlayerSkin.Model.WIDE);
        ModClientEventHandler.addPlayerLayer(evt, PlayerSkin.Model.SLIM);
    }

    private static void addPlayerLayer(EntityRenderersEvent.AddLayers evt, PlayerSkin.Model model) {
        EntityRenderer renderer = evt.getSkin(model);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            livingRenderer.addLayer(new BeltLayer(livingRenderer));
        }
    }
}

