/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.handlers;

import com.tiviacz.travelertoolbelt.config.TravelerToolBeltConfig;
import com.tiviacz.travelertoolbelt.datagen.ModRecipeProvider;
import com.tiviacz.travelertoolbelt.init.ModItems;
import com.tiviacz.travelertoolbelt.init.ModNetwork;
import com.tiviacz.travelertoolbelt.toolbelt.ToolBeltWrapper;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="travelertoolbelt", bus=EventBusSubscriber.Bus.MOD)
public class ModEventHandler {
    @SubscribeEvent
    public static void registerPayloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar payloadRegistrar = event.registrar("travelertoolbelt");
        ModNetwork.register(payloadRegistrar);
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        boolean includeServer = event.includeServer();
        generator.addProvider(includeServer, (DataProvider)new ModRecipeProvider(output, event.getLookupProvider()));
    }

    @SubscribeEvent
    public static void onModConfigLoad(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == TravelerToolBeltConfig.serverSpec) {
            TravelerToolBeltConfig.reload();
        }
    }

    @SubscribeEvent
    public static void onModConfigReload(ModConfigEvent.Reloading configEvent) {
        if (configEvent.getConfig().getSpec() == TravelerToolBeltConfig.serverSpec) {
            TravelerToolBeltConfig.reload();
        }
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, context) -> ToolBeltWrapper.fromStack(stack).getBeltContents(), new ItemLike[]{(ItemLike)ModItems.BELT.get(), (ItemLike)ModItems.COPPER_BELT.get(), (ItemLike)ModItems.IRON_BELT.get(), (ItemLike)ModItems.GOLD_BELT.get(), (ItemLike)ModItems.DIAMOND_BELT.get(), (ItemLike)ModItems.NETHERITE_BELT.get()});
    }
}

