/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.handlers;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tiviacz.travelertoolbelt.ToolBeltHelper;
import com.tiviacz.travelertoolbelt.client.screens.BeltScreen;
import com.tiviacz.travelertoolbelt.client.screens.RadialOverlay;
import com.tiviacz.travelertoolbelt.client.screens.tooltip.BeltTooltipComponent;
import com.tiviacz.travelertoolbelt.handlers.ModClientEventHandler;
import com.tiviacz.travelertoolbelt.item.ToolBeltItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.lwjgl.glfw.GLFW;

@EventBusSubscriber(modid="travelertoolbelt", value={Dist.CLIENT})
public class NeoForgeClientEventHandler {
    @SubscribeEvent
    public static void renderBackpackIcon(ScreenEvent.Render.Post event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Screen screen = mc.screen;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (!ToolBeltItem.isCreative((Player)player)) {
                AbstractContainerMenu menu = screen2.getMenu();
                ItemStack carried = menu.getCarried();
                Slot hoveredSlot = screen2.getSlotUnderMouse();
                Optional<TooltipComponent> tooltip = Optional.empty();
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)screen2.getGuiLeft(), (float)screen2.getGuiTop(), 350.0f);
                for (Slot slot : menu.slots) {
                    ItemStack slotStack = slot.getItem();
                    if (carried.isEmpty() || !ToolBeltHelper.isItemValid(carried) || !(slotStack.getItem() instanceof ToolBeltItem) || !slot.allowModification((Player)player)) continue;
                    tooltip = Optional.of(new BeltTooltipComponent(slotStack));
                    guiGraphics.drawString(mc.font, "+", slot.x + 9, slot.y + 8, ChatFormatting.YELLOW.getColor().intValue());
                    if (slot != hoveredSlot) continue;
                    NeoForgeClientEventHandler.renderBackpackTooltipOnHover(event, mc, tooltip, screen2.getGuiLeft(), screen2.getGuiTop(), 350.0f);
                }
                guiGraphics.pose().popPose();
            }
        }
    }

    private static void renderBackpackTooltipOnHover(ScreenEvent.Render.Post event, Minecraft mc, Optional<TooltipComponent> component, float fx, float fy, float fz) {
        PoseStack poseStack = event.getGuiGraphics().pose();
        poseStack.pushPose();
        poseStack.translate(-fx, -fy, -fz);
        poseStack.translate(0.0f, 0.0f, 100.0f);
        event.getGuiGraphics().renderTooltip(mc.font, List.of(Component.translatable((String)"screen.travelertoolbelt.add").withStyle(ChatFormatting.YELLOW)), component, event.getMouseX(), event.getMouseY());
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderGuiOverlay(RenderGuiLayerEvent.Pre evt) {
        if (evt.getName() == VanillaGuiLayers.CROSSHAIR && Minecraft.getInstance().screen instanceof BeltScreen && !RadialOverlay.drawCrosshair) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void clientTickEvent(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        while (ModClientEventHandler.OPEN_TOOLBELT.consumeClick()) {
            if (mc.screen != null || mc.options.hideGui || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) continue;
            if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof ToolBeltItem) {
                player.displayClientMessage((Component)Component.translatable((String)"screen.travelertoolbelt.cannot_open"), true);
                return;
            }
            ToolBeltHelper.getEquippedToolBelt((LivingEntity)player).ifPresent(pair -> mc.setScreen((Screen)new BeltScreen((ItemStack)pair.getFirst())));
            return;
        }
    }

    @SubscribeEvent
    public static void updateInputEvent(MovementInputUpdateEvent event) {
        if (Minecraft.getInstance().screen instanceof BeltScreen) {
            Options settings = Minecraft.getInstance().options;
            Input eInput = event.getInput();
            eInput.up = NeoForgeClientEventHandler.isKeyDown(settings.keyUp);
            eInput.down = NeoForgeClientEventHandler.isKeyDown(settings.keyDown);
            eInput.left = NeoForgeClientEventHandler.isKeyDown(settings.keyLeft);
            eInput.right = NeoForgeClientEventHandler.isKeyDown(settings.keyRight);
            float f = eInput.up == eInput.down ? 0.0f : (eInput.forwardImpulse = eInput.up ? 1.0f : -1.0f);
            eInput.leftImpulse = eInput.left == eInput.right ? 0.0f : (eInput.left ? 1.0f : -1.0f);
            eInput.jumping = NeoForgeClientEventHandler.isKeyDown(settings.keyJump);
            eInput.shiftKeyDown = NeoForgeClientEventHandler.isKeyDown(settings.keyShift);
            if (Minecraft.getInstance().player.isMovingSlowly()) {
                eInput.leftImpulse = (float)((double)eInput.leftImpulse * 0.3);
                eInput.forwardImpulse = (float)((double)eInput.forwardImpulse * 0.3);
            }
        }
    }

    public static boolean isKeyDown(KeyMapping keybind) {
        if (keybind.isUnbound()) {
            return false;
        }
        return switch (keybind.getKey().getType()) {
            case InputConstants.Type.KEYSYM -> InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keybind.getKey().getValue());
            case InputConstants.Type.MOUSE -> {
                if (GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)keybind.getKey().getValue()) == 1) {
                    yield true;
                }
                yield false;
            }
            default -> keybind.isDown();
        };
    }

    public static boolean isShiftPressed() {
        return GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) == 1 || GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().getWindow(), (int)344) == 1;
    }
}

