/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.item;

import com.tiviacz.travelertoolbelt.ToolBeltHelper;
import com.tiviacz.travelertoolbelt.client.model.BeltLayer;
import com.tiviacz.travelertoolbelt.client.screens.tooltip.BeltTooltipComponent;
import com.tiviacz.travelertoolbelt.handlers.ModClientEventHandler;
import com.tiviacz.travelertoolbelt.handlers.NeoForgeClientEventHandler;
import com.tiviacz.travelertoolbelt.toolbelt.ToolBeltWrapper;
import com.tiviacz.travelertoolbelt.util.InventoryHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class ToolBeltItem
extends Item {
    private final int slotCount;
    private final int type;

    public ToolBeltItem(Item.Properties properties, int type, int slotCount) {
        super(properties.stacksTo(1));
        this.type = type;
        this.slotCount = slotCount;
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    public ResourceLocation getModelTexture() {
        return switch (this.type) {
            case 1 -> BeltLayer.COPPER_BELT;
            case 2 -> BeltLayer.IRON_BELT;
            case 3 -> BeltLayer.GOLD_BELT;
            case 4 -> BeltLayer.DIAMOND_BELT;
            case 5 -> BeltLayer.NETHERITE_BELT;
            default -> BeltLayer.LEATHER_BELT;
        };
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.travelertoolbelt.size", (Object[])new Object[]{Component.literal((String)String.valueOf(this.getSlotCount())).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GOLD));
        if (NeoForgeClientEventHandler.isShiftPressed()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.travelertoolbelt.open_toolbelt_hint", (Object[])new Object[]{Component.literal((String)ModClientEventHandler.OPEN_TOOLBELT.getKey().getDisplayName().getString()).withStyle(ChatFormatting.GRAY)}));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.travelertoolbelt.add_items_hint"));
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.travelertoolbelt.more_info").withStyle(ChatFormatting.GRAY));
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (!slot.mayPlace(stack) || action != ClickAction.SECONDARY) {
            return super.overrideOtherStackedOnMe(stack, other, slot, action, player, access);
        }
        if (other.isEmpty()) {
            ItemStack extracted = InventoryHelper.extractFromBackpack(ToolBeltWrapper.fromStack(stack).getBeltContents(), 64, false);
            if (!extracted.isEmpty()) {
                this.playInsertSound((Entity)player);
                access.set(extracted);
                return true;
            }
        } else if (slot.allowModification(player)) {
            int i = ToolBeltItem.add(player, stack, other, false);
            if (i > 0) {
                this.playInsertSound((Entity)player);
                other.shrink(i);
            }
            return true;
        }
        return super.overrideOtherStackedOnMe(stack, other, slot, action, player, access);
    }

    private static int add(Player player, ItemStack toolbeltStack, ItemStack insertedStack, boolean simulate) {
        int k = insertedStack.getCount();
        if (!insertedStack.isEmpty() && ToolBeltHelper.isItemValid(insertedStack)) {
            ToolBeltWrapper wrapper = ToolBeltWrapper.fromStack(toolbeltStack);
            ItemStack result = InventoryHelper.addItemStackToHandler(wrapper.getBeltContents(), insertedStack, simulate);
            return k - result.getCount();
        }
        return 0;
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new BeltTooltipComponent(stack));
    }

    public static boolean isCreative(Player player) {
        return player.level().isClientSide() && player.containerMenu instanceof CreativeModeInventoryScreen.ItemPickerMenu;
    }
}

