/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelertoolbelt.item.ToolBeltItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class ShapedBeltRecipe
extends ShapedRecipe {
    private final ItemStack result;

    public ShapedBeltRecipe(String groupIn, CraftingBookCategory category, ShapedRecipePattern shapedRecipePattern, ItemStack recipeOutputIn, boolean pShowNotification) {
        super(groupIn, category, shapedRecipePattern, recipeOutputIn, pShowNotification);
        this.result = recipeOutputIn;
    }

    public ItemStack assemble(CraftingInput pInput, HolderLookup.Provider pRegistries) {
        ItemStack output = this.getResultItem(pRegistries).copy();
        if (!output.isEmpty()) {
            for (int i = 0; i < pInput.size(); ++i) {
                ItemStack ingredient = pInput.getItem(i);
                if (!(ingredient.getItem() instanceof ToolBeltItem)) continue;
                output.applyComponents(ingredient.getComponentsPatch());
                break;
            }
        }
        return output;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return RecipeType.CRAFTING;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedBeltRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<ShapedBeltRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340778_ -> p_340778_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_311729_ -> p_311729_.getGroup()), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_311732_ -> p_311732_.category()), (App)ShapedRecipePattern.MAP_CODEC.forGetter(p_311733_ -> p_311733_.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_311730_ -> p_311730_.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(p_311731_ -> p_311731_.showNotification())).apply((Applicative)p_340778_, ShapedBeltRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedBeltRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ShapedBeltRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapedBeltRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapedBeltRecipe fromNetwork(RegistryFriendlyByteBuf p_319998_) {
            String s = p_319998_.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)p_319998_.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern shapedrecipepattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)p_319998_);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)p_319998_);
            boolean flag = p_319998_.readBoolean();
            return new ShapedBeltRecipe(s, craftingbookcategory, shapedrecipepattern, itemstack, flag);
        }

        private static void toNetwork(RegistryFriendlyByteBuf p_320738_, ShapedBeltRecipe p_320586_) {
            p_320738_.writeUtf(p_320586_.getGroup());
            p_320738_.writeEnum((Enum)p_320586_.category());
            ShapedRecipePattern.STREAM_CODEC.encode((Object)p_320738_, (Object)p_320586_.pattern);
            ItemStack.STREAM_CODEC.encode((Object)p_320738_, (Object)p_320586_.result);
            p_320738_.writeBoolean(p_320586_.showNotification());
        }
    }
}

