/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.toolbelt;

import com.tiviacz.travelertoolbelt.ToolBeltHelper;
import com.tiviacz.travelertoolbelt.item.ToolBeltItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ToolBeltWrapper {
    private ItemStackHandler contents;
    private final ItemStack toolbelt;

    public ToolBeltWrapper(ItemStack toolbelt) {
        this.toolbelt = toolbelt;
        this.loadBeltContents();
    }

    public static ToolBeltWrapper fromStack(ItemStack stack) {
        return new ToolBeltWrapper(stack);
    }

    public int getBeltCapacity() {
        return ((ToolBeltItem)this.toolbelt.getItem()).getSlotCount();
    }

    public ItemStackHandler getBeltContents() {
        return this.contents;
    }

    public void loadBeltContents() {
        if (this.toolbelt.has(DataComponents.CONTAINER)) {
            ItemContainerContents contents = (ItemContainerContents)this.toolbelt.get(DataComponents.CONTAINER);
            NonNullList stacks = NonNullList.withSize((int)this.getBeltCapacity(), (Object)ItemStack.EMPTY);
            contents.copyInto(stacks);
            this.contents = this.createHandler((NonNullList<ItemStack>)stacks);
        } else {
            this.contents = this.createHandler((NonNullList<ItemStack>)NonNullList.withSize((int)this.getBeltCapacity(), (Object)ItemStack.EMPTY));
        }
    }

    public void setSlotChanged() {
        this.toolbelt.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getListContents()));
    }

    public List<ItemStack> getListContents() {
        ArrayList<ItemStack> listContents = new ArrayList<ItemStack>();
        for (int i = 0; i < this.contents.getSlots(); ++i) {
            listContents.add(this.contents.getStackInSlot(i));
        }
        return listContents;
    }

    private ItemStackHandler createHandler(NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                ToolBeltWrapper.this.setSlotChanged();
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return ToolBeltHelper.isItemValid(stack);
            }
        };
    }
}

