/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelertoolbelt.TravelerToolBelt;
import com.tiviacz.travelertoolbelt.config.TravelerToolBeltConfig;
import com.tiviacz.travelertoolbelt.item.ToolBeltItem;
import com.tiviacz.travelertoolbelt.toolbelt.ItemStackHandler;
import com.tiviacz.travelertoolbelt.toolbelt.ToolBeltWrapper;
import com.tiviacz.travelertoolbelt.util.InventoryHelper;
import dev.emi.trinkets.api.TrinketsApi;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;

public class ToolBeltHelper {
    public static Optional<Pair<class_1799, Integer>> getEquippedToolBelt(class_1309 livingEntity) {
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            if (TravelerToolBelt.trinketsLoaded) {
                AtomicReference<class_1799> toolbelt = new AtomicReference<class_1799>(class_1799.field_8037);
                TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinketComponent -> {
                    if (trinketComponent.isEquipped(p -> p.method_7909() instanceof ToolBeltItem)) {
                        toolbelt.set((class_1799)((class_3545)trinketComponent.getEquipped(t -> t.method_7909() instanceof ToolBeltItem).get(0)).method_15441());
                    }
                });
                return toolbelt.get().method_7960() ? Optional.empty() : Optional.of(Pair.of((Object)toolbelt.get(), (Object)-1));
            }
            if (TravelerToolBelt.accessoriesLoaded) {
                AtomicReference<class_1799> toolbelt = new AtomicReference<class_1799>(class_1799.field_8037);
                AccessoriesCapability.getOptionally((class_1309)player).ifPresent(accessories -> {
                    if (accessories.isEquipped(p -> p.method_7909() instanceof ToolBeltItem)) {
                        toolbelt.set(accessories.getFirstEquipped(p -> p.method_7909() instanceof ToolBeltItem).stack());
                    }
                });
                return toolbelt.get().method_7960() ? Optional.empty() : Optional.of(Pair.of((Object)toolbelt.get(), (Object)-1));
            }
            for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                class_1799 stack = (class_1799)player.method_31548().field_7547.get(i);
                if (!(stack.method_7909() instanceof ToolBeltItem)) continue;
                return Optional.of(Pair.of((Object)stack, (Object)i));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static Optional<class_1799> getEquippedToolBeltForRendering(class_1309 livingEntity) {
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            if (TravelerToolBelt.trinketsLoaded) {
                AtomicReference<class_1799> toolbelt = new AtomicReference<class_1799>(class_1799.field_8037);
                TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinketComponent -> {
                    if (trinketComponent.isEquipped(p -> p.method_7909() instanceof ToolBeltItem)) {
                        toolbelt.set((class_1799)((class_3545)trinketComponent.getEquipped(t -> t.method_7909() instanceof ToolBeltItem).get(0)).method_15441());
                    }
                });
                return toolbelt.get().method_7960() ? Optional.empty() : Optional.of(toolbelt.get());
            }
            if (TravelerToolBelt.accessoriesLoaded) {
                AtomicReference<class_1799> toolbelt = new AtomicReference<class_1799>(class_1799.field_8037);
                AccessoriesCapability.getOptionally((class_1309)player).ifPresent(accessories -> {
                    if (accessories.isEquipped(p -> p.method_7909() instanceof ToolBeltItem)) {
                        SlotEntryReference context = accessories.getFirstEquipped(p -> p.method_7909() instanceof ToolBeltItem);
                        boolean visible = context.reference().slotContainer().shouldRender(context.reference().slot());
                        toolbelt.set(visible ? context.stack() : class_1799.field_8037);
                    }
                });
                return toolbelt.get().method_7960() ? Optional.empty() : Optional.of(toolbelt.get());
            }
            for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                class_1799 stack = (class_1799)player.method_31548().field_7547.get(i);
                if (!(stack.method_7909() instanceof ToolBeltItem)) continue;
                return Optional.of(stack);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static Optional<ToolBeltWrapper> getEquippedToolBeltWrapper(class_1657 player) {
        return ToolBeltHelper.getEquippedToolBelt((class_1309)player).map(p -> ToolBeltWrapper.fromStack((class_1799)p.getFirst()));
    }

    public static boolean isItemValid(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (stack.method_7960()) {
            return false;
        }
        if (TravelerToolBeltConfig.whitelist.stream().anyMatch(i -> i == item)) {
            return true;
        }
        if (TravelerToolBeltConfig.blacklist.stream().anyMatch(i -> i == item)) {
            return false;
        }
        if (stack.method_7909() instanceof ToolBeltItem) {
            return false;
        }
        return (Boolean)TravelerToolBeltConfig.SERVER.allowAllNonStackableItems.get() != false && stack.method_7914() == 1 || (Boolean)TravelerToolBeltConfig.SERVER.allowAllItems.get() != false;
    }

    public static void swapTool(class_1657 player, int slot) {
        ToolBeltHelper.getEquippedToolBelt((class_1309)player).ifPresent(pair -> {
            class_1799 handStack = player.method_6047().method_7972();
            if (!ToolBeltHelper.isItemValid(handStack) && !handStack.method_7960()) {
                return;
            }
            ToolBeltWrapper wrapper = ToolBeltWrapper.fromStack((class_1799)pair.getFirst());
            ItemStackHandler inv = wrapper.getBeltContents();
            if (slot == -999) {
                class_1799 stack = InventoryHelper.addItemStackToHandler(inv, handStack, false);
                if (stack.method_7960()) {
                    player.method_6122(class_1268.field_5808, class_1799.field_8037);
                }
            } else {
                class_1799 currentTool = inv.getStackInSlot(slot).method_7972();
                player.method_6122(class_1268.field_5808, currentTool);
                inv.setStackInSlot(slot, handStack);
            }
            player.method_37908().method_60511(null, player.method_19538().method_10216(), player.method_19538().method_10214() + 0.5, player.method_19538().method_10215(), class_3417.field_14581, class_3419.field_15245, 1.0f, 1.0f);
        });
    }
}

