/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelertoolbelt.config.TravelerToolBeltConfig;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4597;
import net.minecraft.class_5348;

public final class RadialOverlay {
    public static final class_2960 OVERLAY = class_2960.method_60655((String)"travelertoolbelt", (String)"textures/gui/belt_overlay.png");
    private static final int ICON_SIZE = 16;
    private static final int ITEM_RING_RADIUS = 42;
    private static final int DEADZONE_RADIUS = 30;
    public static final int ADD_NEW = -999;
    public static boolean drawCrosshair = true;

    public static void blitCentered(class_332 guiGraphics, class_2960 texture, int centerX, int centerY, int size) {
        int x = centerX - size / 2;
        int y = centerY - size / 2;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25290(texture, x, y, 0.0f, 0.0f, size, size, size, size);
        RenderSystem.disableBlend();
    }

    private static void beginRadialTransform(class_332 guiGraphics, int centerX, int centerY, float openProgress) {
        float t = openProgress = class_3532.method_15363((float)openProgress, (float)0.0f, (float)1.0f);
        float scale = t = t * t * (3.0f - 2.0f * t);
        float opacity = t;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)centerX, (float)centerY, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
        guiGraphics.method_51448().method_46416((float)(-centerX), (float)(-centerY), 0.0f);
    }

    private static void endRadialTransform(class_332 guiGraphics) {
        guiGraphics.method_51448().method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static ArrayList<Integer> buildSegToSlot(class_2371<class_1799> tools, boolean canAdd, int[] outPlusSlot) {
        ArrayList<Integer> segToSlot = new ArrayList<Integer>();
        for (int i = 0; i < tools.size(); ++i) {
            if (((class_1799)tools.get(i)).method_7960()) continue;
            segToSlot.add(i);
        }
        int plusSlot = -1;
        if (canAdd) {
            for (int i = 0; i < tools.size(); ++i) {
                if (!((class_1799)tools.get(i)).method_7960()) continue;
                plusSlot = i;
                break;
            }
            if (plusSlot != -1) {
                int insertPos;
                for (insertPos = 0; insertPos < segToSlot.size() && segToSlot.get(insertPos) < plusSlot; ++insertPos) {
                }
                segToSlot.add(insertPos, plusSlot);
            }
        }
        outPlusSlot[0] = plusSlot;
        return segToSlot;
    }

    public static void renderRadialBackground(class_332 guiGraphics, int centerX, int centerY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        RadialOverlay.blitCentered(guiGraphics, OVERLAY, centerX, centerY, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static int renderRadialItems(class_332 guiGraphics, class_1799 toolbelt, class_2371<class_1799> tools, boolean canAdd, boolean handEmpty, ArrayList<Integer> segToSlot, int plusSlot, int centerX, int centerY, int mouseX, int mouseY) {
        class_1799 hoveredStack;
        class_310 mc = class_310.method_1551();
        class_327 font = mc.field_1772;
        int segments = segToSlot.size();
        int hoveredSeg = RadialOverlay.getHoveredIndex(centerX, centerY, mouseX, mouseY, segments);
        int hoveredResult = -1;
        boolean hoveredIsPlus = false;
        if (hoveredSeg >= 0 && hoveredSeg < segToSlot.size()) {
            int slot = segToSlot.get(hoveredSeg);
            hoveredIsPlus = canAdd && plusSlot != -1 && slot == plusSlot && ((class_1799)tools.get(slot)).method_7960();
            int n = hoveredResult = hoveredIsPlus ? -999 : slot;
        }
        if (segments == 0 && hoveredSeg == -1) {
            return -1;
        }
        float step = (float)(Math.PI * 2 / (double)segments);
        float start = -1.5707964f;
        for (int seg = 0; seg < segments; ++seg) {
            boolean isPlusHere;
            boolean isHovered;
            float ang = start + (float)seg * step;
            int x = centerX + class_3532.method_15375((float)(class_3532.method_15362((float)ang) * 42.0f)) - 8;
            int y = centerY + class_3532.method_15375((float)(class_3532.method_15374((float)ang) * 42.0f)) - 8;
            boolean bl = isHovered = seg == hoveredSeg;
            if (isHovered) {
                guiGraphics.method_25294(x - 2, y - 2, x + 16 + 2, y + 16 + 2, -2130706433);
            }
            int slot = segToSlot.get(seg);
            boolean bl2 = isPlusHere = canAdd && plusSlot != -1 && slot == plusSlot && ((class_1799)tools.get(slot)).method_7960();
            if (isPlusHere) {
                RadialOverlay.renderPlusButton(guiGraphics, font, x, y);
                continue;
            }
            class_1799 stack = (class_1799)tools.get(slot);
            guiGraphics.method_51427(stack, x, y);
            guiGraphics.method_51431(font, stack, x, y);
        }
        if (hoveredIsPlus) {
            guiGraphics.method_51438(font, (class_2561)class_2561.method_43471((String)"screen.travelertoolbelt.add"), mouseX, mouseY);
        } else if (hoveredResult >= 0 && !(hoveredStack = (class_1799)tools.get(hoveredResult)).method_7960()) {
            RadialOverlay.renderCenteredText(guiGraphics, (class_2561)(handEmpty ? class_2561.method_43471((String)"screen.travelertoolbelt.take") : class_2561.method_43471((String)"screen.travelertoolbelt.swap")), centerX, centerY);
            if (((Boolean)TravelerToolBeltConfig.CLIENT.showTooltip.get()).booleanValue()) {
                guiGraphics.method_51446(font, hoveredStack, mouseX, mouseY);
            } else {
                guiGraphics.method_51438(font, hoveredStack.method_7964(), mouseX, mouseY);
            }
        }
        return hoveredResult;
    }

    public static int renderRadial(class_332 guiGraphics, class_1799 backpack, class_1799 heldItem, class_2371<class_1799> tools, boolean canAdd, int centerX, int centerY, int mouseX, int mouseY, float partialTick, float openProgress) {
        drawCrosshair = true;
        if (tools == null) {
            return -1;
        }
        RadialOverlay.beginRadialTransform(guiGraphics, centerX, centerY, openProgress);
        int[] plusSlotRef = new int[1];
        ArrayList<Integer> segToSlot = RadialOverlay.buildSegToSlot(tools, canAdd, plusSlotRef);
        int plusSlot = plusSlotRef[0];
        RadialOverlay.renderRadialBackground(guiGraphics, centerX, centerY);
        int result = RadialOverlay.renderRadialItems(guiGraphics, backpack, tools, canAdd, heldItem.method_7960(), segToSlot, plusSlot, centerX, centerY, mouseX, mouseY);
        RadialOverlay.endRadialTransform(guiGraphics);
        return result;
    }

    public static int getHoveredIndex(int cx, int cy, int mx, int my, int segments) {
        if (segments == 0) {
            return -1;
        }
        int dx = mx - cx;
        int dy = my - cy;
        if (dx * dx + dy * dy < 900) {
            return -1;
        }
        double ang = Math.atan2(dy, dx);
        ang = RadialOverlay.normalize0To2Pi(ang);
        double start = 4.71238898038469;
        double rel = RadialOverlay.normalize0To2Pi(ang - start);
        double step = Math.PI * 2 / (double)segments;
        int idx = (int)Math.floor((rel + step / 2.0) / step);
        idx = (idx % segments + segments) % segments;
        return idx;
    }

    private static void renderCenteredText(class_332 guiGraphics, class_2561 text, int centerX, int centerY) {
        drawCrosshair = false;
        class_327 textRenderer = class_310.method_1551().field_1772;
        int textWidth = textRenderer.method_27525((class_5348)text);
        Objects.requireNonNull(textRenderer);
        int textHeight = 9;
        int textX = centerX - textWidth / 2;
        int textY = centerY - textHeight / 2;
        guiGraphics.method_51439(class_310.method_1551().field_1772, text, textX, textY, 0xFFFFFF, true);
    }

    private static void renderPlusButton(class_332 guiGraphics, class_327 font, int x, int y) {
        String plus = "+";
        float s = 1.25f;
        float px = (float)x + 8.0f - (float)font.method_1727(plus) / 2.0f;
        float f = (float)y + 8.0f;
        Objects.requireNonNull(font);
        float py = f - 9.0f / 2.0f;
        float cx = (float)x + 8.0f;
        float cy = (float)y + 8.0f;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(cx, cy, 0.0f);
        guiGraphics.method_51448().method_22905(s, s, 1.0f);
        guiGraphics.method_51448().method_46416(-cx, -cy, 0.0f);
        RadialOverlay.drawString(guiGraphics, font, plus, px + 0.5f, py + 1.0f, 0xFFFFFF, false);
        guiGraphics.method_51448().method_22909();
    }

    public static int drawString(class_332 guiGraphics, class_327 pFont, String pText, float pX, float pY, int pColor, boolean pDropShadow) {
        if (pText == null) {
            return 0;
        }
        int i = pFont.method_27522(pText, pX, pY, pColor, pDropShadow, guiGraphics.method_51448().method_23760().method_23761(), (class_4597)guiGraphics.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0, pFont.method_1726());
        guiGraphics.method_51744();
        return i;
    }

    private static double normalize0To2Pi(double a) {
        double twoPi = Math.PI * 2;
        if ((a %= twoPi) < 0.0) {
            a += twoPi;
        }
        return a;
    }
}

