/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.item;

import com.tiviacz.travelertoolbelt.ToolBeltHelper;
import com.tiviacz.travelertoolbelt.client.model.BeltLayer;
import com.tiviacz.travelertoolbelt.client.screens.tooltip.BeltTooltipComponent;
import com.tiviacz.travelertoolbelt.handlers.KeybindHandler;
import com.tiviacz.travelertoolbelt.toolbelt.ToolBeltWrapper;
import com.tiviacz.travelertoolbelt.util.InventoryHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_481;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;

public class ToolBeltItem
extends class_1792 {
    private final int slotCount;
    private final int type;

    public ToolBeltItem(class_1792.class_1793 properties, int type, int slotCount) {
        super(properties.method_7889(1));
        this.type = type;
        this.slotCount = slotCount;
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    public class_2960 getModelTexture() {
        return switch (this.type) {
            case 1 -> BeltLayer.COPPER_BELT;
            case 2 -> BeltLayer.IRON_BELT;
            case 3 -> BeltLayer.GOLD_BELT;
            case 4 -> BeltLayer.DIAMOND_BELT;
            case 5 -> BeltLayer.NETHERITE_BELT;
            default -> BeltLayer.LEATHER_BELT;
        };
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((class_2561)class_2561.method_43469((String)"tooltip.travelertoolbelt.size", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(this.getSlotCount())).method_27692(class_124.field_1054)}).method_27692(class_124.field_1065));
        if (KeybindHandler.isShiftPressed()) {
            tooltipComponents.add((class_2561)class_2561.method_43469((String)"tooltip.travelertoolbelt.open_toolbelt_hint", (Object[])new Object[]{class_2561.method_43470((String)KeybindHandler.OPEN_TOOLBELT.field_1655.method_27445().getString()).method_27692(class_124.field_1080)}));
            tooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.travelertoolbelt.add_items_hint"));
            return;
        }
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.travelertoolbelt.more_info").method_27692(class_124.field_1080));
    }

    public boolean method_31566(class_1799 stack, class_1799 other, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        if (!slot.method_7680(stack) || action != class_5536.field_27014) {
            return super.method_31566(stack, other, slot, action, player, access);
        }
        if (other.method_7960()) {
            class_1799 extracted = InventoryHelper.extractFromBackpack(ToolBeltWrapper.fromStack(stack).getBeltContents(), 64, false);
            if (!extracted.method_7960()) {
                this.playInsertSound((class_1297)player);
                access.method_32332(extracted);
                return true;
            }
        } else if (slot.method_32754(player)) {
            int i = ToolBeltItem.add(player, stack, other, false);
            if (i > 0) {
                this.playInsertSound((class_1297)player);
                other.method_7934(i);
            }
            return true;
        }
        return super.method_31566(stack, other, slot, action, player, access);
    }

    private static int add(class_1657 player, class_1799 toolbeltStack, class_1799 insertedStack, boolean simulate) {
        int k = insertedStack.method_7947();
        if (!insertedStack.method_7960() && ToolBeltHelper.isItemValid(insertedStack)) {
            ToolBeltWrapper wrapper = ToolBeltWrapper.fromStack(toolbeltStack);
            class_1799 result = InventoryHelper.addItemStackToHandler(wrapper.getBeltContents(), insertedStack, simulate);
            return k - result.method_7947();
        }
        return 0;
    }

    private void playInsertSound(class_1297 pEntity) {
        pEntity.method_5783(class_3417.field_34376, 0.8f, 0.8f + pEntity.method_37908().method_8409().method_43057() * 0.4f);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.of(new BeltTooltipComponent(stack));
    }

    public static boolean isCreative(class_1657 player) {
        return player.method_37908().method_8608() && player.field_7512 instanceof class_481.class_483;
    }
}

