/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tiviacz.travelertoolbelt.recipe.ShapedBeltRecipe;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_8957;
import org.jetbrains.annotations.Nullable;

public class ShapedBeltRecipeBuilder
implements class_5797 {
    private final class_7800 category;
    private final class_1792 result;
    private final int count;
    private final class_1799 resultStack;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, class_1856> key = Maps.newLinkedHashMap();
    private final Map<String, class_175<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private boolean showNotification = true;

    public ShapedBeltRecipeBuilder(class_7800 pCategory, class_1935 pResult, int pCount) {
        this(pCategory, new class_1799(pResult, pCount));
    }

    public ShapedBeltRecipeBuilder(class_7800 p_249996_, class_1799 result) {
        this.category = p_249996_;
        this.result = result.method_7909();
        this.count = result.method_7947();
        this.resultStack = result;
    }

    public static ShapedBeltRecipeBuilder shaped(class_7800 pCategory, class_1935 pResult) {
        return ShapedBeltRecipeBuilder.shaped(pCategory, pResult, 1);
    }

    public static ShapedBeltRecipeBuilder shaped(class_7800 pCategory, class_1935 pResult, int pCount) {
        return new ShapedBeltRecipeBuilder(pCategory, pResult, pCount);
    }

    public static ShapedBeltRecipeBuilder shaped(class_7800 p_251325_, class_1799 result) {
        return new ShapedBeltRecipeBuilder(p_251325_, result);
    }

    public ShapedBeltRecipeBuilder define(Character pSymbol, class_6862<class_1792> pTag) {
        return this.define(pSymbol, class_1856.method_8106(pTag));
    }

    public ShapedBeltRecipeBuilder define(Character pSymbol, class_1935 pItem) {
        return this.define(pSymbol, class_1856.method_8091((class_1935[])new class_1935[]{pItem}));
    }

    public ShapedBeltRecipeBuilder define(Character pSymbol, class_1856 pIngredient) {
        if (this.key.containsKey(pSymbol)) {
            throw new IllegalArgumentException("Symbol '" + pSymbol + "' is already defined!");
        }
        if (pSymbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(pSymbol, pIngredient);
        return this;
    }

    public ShapedBeltRecipeBuilder pattern(String pPattern) {
        if (!this.rows.isEmpty() && pPattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pPattern);
        return this;
    }

    public ShapedBeltRecipeBuilder unlockedBy(String pName, class_175<?> pCriterion) {
        this.criteria.put(pName, pCriterion);
        return this;
    }

    public ShapedBeltRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public ShapedBeltRecipeBuilder showNotification(boolean pShowNotification) {
        this.showNotification = pShowNotification;
        return this;
    }

    public class_1792 method_36441() {
        return this.result;
    }

    public void method_17972(class_8790 pRecipeOutput, class_2960 pId) {
        class_8957 shapedrecipepattern = this.ensureValid(pId);
        class_161.class_162 advancement$builder = pRecipeOutput.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)pId)).method_703(class_170.class_171.method_753((class_2960)pId)).method_704(class_8782.class_8797.field_1257);
        this.criteria.forEach((arg_0, arg_1) -> ((class_161.class_162)advancement$builder).method_705(arg_0, arg_1));
        ShapedBeltRecipe shapedbackpackrecipe = new ShapedBeltRecipe(Objects.requireNonNullElse(this.group, ""), class_5797.method_55308((class_7800)this.category), shapedrecipepattern, this.resultStack, this.showNotification);
        pRecipeOutput.method_53819(pId, (class_1860)shapedbackpackrecipe, advancement$builder.method_695(pId.method_45138("recipes/" + this.category.method_46203() + "/")));
    }

    private class_8957 ensureValid(class_2960 pLocation) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(pLocation));
        }
        return class_8957.method_55085(this.key, this.rows);
    }
}

