/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelertoolbelt.TravelerToolBelt;
import com.tiviacz.travelertoolbelt.config.TravelerToolBeltConfig;
import com.tiviacz.travelertoolbelt.item.ToolBeltItem;
import com.tiviacz.travelertoolbelt.toolbelt.ToolBeltWrapper;
import com.tiviacz.travelertoolbelt.util.InventoryHelper;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class ToolBeltHelper {
    public static Optional<Pair<ItemStack, Integer>> getEquippedToolBelt(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (TravelerToolBelt.curiosLoaded) {
                AtomicReference<ItemStack> toolbelt = new AtomicReference<ItemStack>(ItemStack.f_41583_);
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curios -> {
                    if (curios.isEquipped(p -> p.m_41720_() instanceof ToolBeltItem)) {
                        toolbelt.set(curios.findFirstCurio(t -> t.m_41720_() instanceof ToolBeltItem).map(SlotResult::stack).orElse(ItemStack.f_41583_));
                    }
                });
                return toolbelt.get().m_41619_() ? Optional.empty() : Optional.of(Pair.of((Object)toolbelt.get(), (Object)-1));
            }
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (!(stack.m_41720_() instanceof ToolBeltItem)) continue;
                return Optional.of(Pair.of((Object)stack, (Object)i));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> getEquippedToolBeltForRendering(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (TravelerToolBelt.curiosLoaded) {
                AtomicReference<ItemStack> toolbelt = new AtomicReference<ItemStack>(ItemStack.f_41583_);
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curios -> {
                    if (curios.isEquipped(p -> p.m_41720_() instanceof ToolBeltItem)) {
                        toolbelt.set(curios.findFirstCurio(t -> t.m_41720_() instanceof ToolBeltItem).map(slotResult -> slotResult.slotContext().visible() ? slotResult.stack() : ItemStack.f_41583_).orElse(ItemStack.f_41583_));
                    }
                });
                return toolbelt.get().m_41619_() ? Optional.empty() : Optional.of(toolbelt.get());
            }
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (!(stack.m_41720_() instanceof ToolBeltItem)) continue;
                return Optional.of(stack);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static Optional<ToolBeltWrapper> getEquippedToolBeltWrapper(Player player) {
        return ToolBeltHelper.getEquippedToolBelt((LivingEntity)player).map(p -> ToolBeltWrapper.fromStack((ItemStack)p.getFirst()));
    }

    public static boolean isItemValid(ItemStack stack) {
        Item item = stack.m_41720_();
        if (stack.m_41619_()) {
            return false;
        }
        if (TravelerToolBeltConfig.whitelist.stream().anyMatch(i -> i == item)) {
            return true;
        }
        if (TravelerToolBeltConfig.blacklist.stream().anyMatch(i -> i == item)) {
            return false;
        }
        if (stack.m_41720_() instanceof ToolBeltItem) {
            return false;
        }
        return (Boolean)TravelerToolBeltConfig.SERVER.allowAllNonStackableItems.get() != false && stack.m_41741_() == 1 || (Boolean)TravelerToolBeltConfig.SERVER.allowAllItems.get() != false;
    }

    public static void swapTool(Player player, int slot) {
        ToolBeltHelper.getEquippedToolBelt((LivingEntity)player).ifPresent(pair -> {
            ItemStack handStack = player.m_21205_().m_41777_();
            if (!ToolBeltHelper.isItemValid(handStack) && !handStack.m_41619_()) {
                return;
            }
            ToolBeltWrapper wrapper = ToolBeltWrapper.fromStack((ItemStack)pair.getFirst());
            ItemStackHandler inv = wrapper.getBeltContents();
            if (slot == -999) {
                ItemStack stack = InventoryHelper.addItemStackToHandler(inv, handStack, false);
                if (stack.m_41619_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
            } else {
                ItemStack currentTool = inv.getStackInSlot(slot).m_41777_();
                player.m_21008_(InteractionHand.MAIN_HAND, currentTool);
                inv.setStackInSlot(slot, handStack);
            }
            player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_() + 0.5, player.m_20182_().m_7094_(), SoundEvents.f_11678_, SoundSource.BLOCKS, 1.0f, 1.0f);
        });
    }
}

