/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tiviacz.travelertoolbelt.ToolBeltHelper;
import com.tiviacz.travelertoolbelt.client.model.BeltModel;
import com.tiviacz.travelertoolbelt.handlers.ModClientEventHandler;
import com.tiviacz.travelertoolbelt.item.ToolBeltItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;

public class BeltLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public static final ResourceLocation LEATHER_BELT = new ResourceLocation("travelertoolbelt", "textures/entity/belt.png");
    public static final ResourceLocation COPPER_BELT = new ResourceLocation("travelertoolbelt", "textures/entity/copper_belt.png");
    public static final ResourceLocation IRON_BELT = new ResourceLocation("travelertoolbelt", "textures/entity/iron_belt.png");
    public static final ResourceLocation GOLD_BELT = new ResourceLocation("travelertoolbelt", "textures/entity/gold_belt.png");
    public static final ResourceLocation DIAMOND_BELT = new ResourceLocation("travelertoolbelt", "textures/entity/diamond_belt.png");
    public static final ResourceLocation NETHERITE_BELT = new ResourceLocation("travelertoolbelt", "textures/entity/netherite_belt.png");
    private final BeltModel<T> beltModel = new BeltModel(Minecraft.m_91087_().m_167973_().m_171103_(ModClientEventHandler.BELT_LAYER));

    public BeltLayer(RenderLayerParent<T, M> owner) {
        super(owner);
    }

    private void translateToBody(LivingEntity entity, PoseStack poseStack) {
        ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
        if (entity.m_6162_() && !(entity instanceof Villager)) {
            poseStack.m_85841_(0.52f, 0.52f, 0.52f);
            poseStack.m_85837_(0.0, 1.4, 0.0);
        }
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int lightness, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ToolBeltHelper.getEquippedToolBeltForRendering(entity).ifPresent(belt -> {
            matrixStack.m_85836_();
            this.translateToBody((LivingEntity)entity, matrixStack);
            matrixStack.m_85841_(1.05f, 1.05f, 1.05f);
            BeltLayer.m_117376_(this.beltModel, (ResourceLocation)this.getTextureLocation(entity), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)lightness, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.m_85849_();
        });
    }

    protected ResourceLocation getTextureLocation(T pEntity) {
        return ToolBeltHelper.getEquippedToolBeltForRendering(pEntity).map(belt -> ((ToolBeltItem)belt.m_41720_()).getModelTexture()).orElse(LEATHER_BELT);
    }
}

