/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.client.screens;

import com.mojang.blaze3d.platform.Window;
import com.tiviacz.travelertoolbelt.ToolBeltHelper;
import com.tiviacz.travelertoolbelt.client.screens.RadialOverlay;
import com.tiviacz.travelertoolbelt.config.TravelerToolBeltConfig;
import com.tiviacz.travelertoolbelt.handlers.ForgeClientEventHandler;
import com.tiviacz.travelertoolbelt.handlers.ModClientEventHandler;
import com.tiviacz.travelertoolbelt.item.ToolBeltItem;
import com.tiviacz.travelertoolbelt.network.ServerboundSwapToolPacket;
import com.tiviacz.travelertoolbelt.util.NbtHelper;
import com.tiviacz.travelertoolbelt.util.PacketDistributorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.lwjgl.glfw.GLFW;

public class BeltScreen
extends Screen {
    private static final double REF_W = 1920.0;
    private static final double REF_H = 1080.0;
    private long openStartMs = -1L;
    private final ItemStack toolbelt;

    public BeltScreen(ItemStack toolbelt) {
        super((Component)Component.m_237115_((String)"screen.travelertoolbelt.belt"));
        this.toolbelt = toolbelt;
    }

    private float getOpenProgress() {
        long now = System.currentTimeMillis();
        if (this.openStartMs < 0L) {
            this.openStartMs = now;
        }
        float durMs = 180.0f;
        return Mth.m_14036_((float)((float)(now - this.openStartMs) / durMs), (float)0.0f, (float)1.0f);
    }

    protected void m_7856_() {
        super.m_7856_();
        Window mainWindow = Minecraft.m_91087_().m_91268_();
        int sw = mainWindow.m_85443_();
        int sh = mainWindow.m_85444_();
        int cx = sw / 2;
        int cy = sh / 2;
        int offXpx = (Integer)TravelerToolBeltConfig.CLIENT.offsetX.get();
        int offYpx = (Integer)TravelerToolBeltConfig.CLIENT.offsetY.get();
        double px = (double)offXpx / 1920.0;
        double py = (double)offYpx / 1080.0;
        int scaledWidth = (int)Math.round((double)cx + px * (double)sw);
        int scaledHeight = (int)Math.round((double)cy + py * (double)sh);
        GLFW.glfwSetCursorPos((long)Minecraft.m_91087_().m_91268_().m_85439_(), (double)scaledWidth, (double)scaledHeight);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean canAdd;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        Window mainWindow = mc.m_91268_();
        int sw = mainWindow.m_85445_();
        int sh = mainWindow.m_85446_();
        int cx = sw / 2;
        int cy = sh / 2;
        int offXpx = (Integer)TravelerToolBeltConfig.CLIENT.offsetX.get();
        int offYpx = (Integer)TravelerToolBeltConfig.CLIENT.offsetY.get();
        double px = (double)offXpx / 1920.0;
        double py = (double)offYpx / 1080.0;
        int scaledWidth = (int)Math.round((double)cx + px * (double)sw);
        int scaledHeight = (int)Math.round((double)cy + py * (double)sh);
        float progress = this.getOpenProgress();
        ItemStack heldItem = player.m_21205_();
        int toolbeltSize = ((ToolBeltItem)this.toolbelt.m_41720_()).getSlotCount();
        NonNullList<ItemStack> tools = NbtHelper.getOrDefault(this.toolbelt, "BeltContainer", NonNullList.m_122780_((int)toolbeltSize, (Object)ItemStack.f_41583_));
        int nonEmptyCount = BeltScreen.getNonEmptyTools(tools).size();
        boolean bl = canAdd = ToolBeltHelper.isItemValid(heldItem) && nonEmptyCount < toolbeltSize;
        if (tools.size() < toolbeltSize) {
            tools = BeltScreen.getExpandedTools(tools, toolbeltSize);
        }
        int hoveredResult = RadialOverlay.renderRadial(graphics, this.toolbelt, heldItem, tools, canAdd, scaledWidth, scaledHeight, mouseX, mouseY, partialTick, progress);
        if (!ForgeClientEventHandler.isKeyDown(ModClientEventHandler.OPEN_TOOLBELT)) {
            if (hoveredResult != -1) {
                PacketDistributorHelper.sendToServer(new ServerboundSwapToolPacket(hoveredResult));
            }
            this.m_7379_();
        }
    }

    public static NonNullList<ItemStack> getExpandedTools(NonNullList<ItemStack> tools, int expectedSize) {
        NonNullList expanded = NonNullList.m_122779_();
        for (int i = 0; i < expectedSize; ++i) {
            if (i < tools.size()) {
                expanded.add((Object)((ItemStack)tools.get(i)));
                continue;
            }
            expanded.add((Object)ItemStack.f_41583_);
        }
        return expanded;
    }

    public static NonNullList<ItemStack> getNonEmptyTools(NonNullList<ItemStack> inventory) {
        NonNullList tools = NonNullList.m_122779_();
        for (ItemStack itemStack : inventory) {
            if (itemStack.m_41619_()) continue;
            tools.add((Object)itemStack);
        }
        return tools;
    }

    public boolean m_7043_() {
        return false;
    }
}

