/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelertoolbelt.config.TravelerToolBeltConfig;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public final class RadialOverlay {
    public static final ResourceLocation OVERLAY = new ResourceLocation("travelertoolbelt", "textures/gui/belt_overlay.png");
    private static final int ICON_SIZE = 16;
    private static final int ITEM_RING_RADIUS = 42;
    private static final int DEADZONE_RADIUS = 30;
    public static final int ADD_NEW = -999;
    public static boolean drawCrosshair = true;

    public static void blitCentered(GuiGraphics guiGraphics, ResourceLocation texture, int centerX, int centerY, int size) {
        int x = centerX - size / 2;
        int y = centerY - size / 2;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280163_(texture, x, y, 0.0f, 0.0f, size, size, size, size);
        RenderSystem.disableBlend();
    }

    private static void beginRadialTransform(GuiGraphics guiGraphics, int centerX, int centerY, float openProgress) {
        float t = openProgress = Mth.m_14036_((float)openProgress, (float)0.0f, (float)1.0f);
        float scale = t = t * t * (3.0f - 2.0f * t);
        float opacity = t;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)centerX, (float)centerY, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280168_().m_252880_((float)(-centerX), (float)(-centerY), 0.0f);
    }

    private static void endRadialTransform(GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static ArrayList<Integer> buildSegToSlot(NonNullList<ItemStack> tools, boolean canAdd, int[] outPlusSlot) {
        ArrayList<Integer> segToSlot = new ArrayList<Integer>();
        for (int i = 0; i < tools.size(); ++i) {
            if (((ItemStack)tools.get(i)).m_41619_()) continue;
            segToSlot.add(i);
        }
        int plusSlot = -1;
        if (canAdd) {
            for (int i = 0; i < tools.size(); ++i) {
                if (!((ItemStack)tools.get(i)).m_41619_()) continue;
                plusSlot = i;
                break;
            }
            if (plusSlot != -1) {
                int insertPos;
                for (insertPos = 0; insertPos < segToSlot.size() && segToSlot.get(insertPos) < plusSlot; ++insertPos) {
                }
                segToSlot.add(insertPos, plusSlot);
            }
        }
        outPlusSlot[0] = plusSlot;
        return segToSlot;
    }

    public static void renderRadialBackground(GuiGraphics guiGraphics, int centerX, int centerY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        RadialOverlay.blitCentered(guiGraphics, OVERLAY, centerX, centerY, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static int renderRadialItems(GuiGraphics guiGraphics, ItemStack toolbelt, NonNullList<ItemStack> tools, boolean canAdd, boolean handEmpty, ArrayList<Integer> segToSlot, int plusSlot, int centerX, int centerY, int mouseX, int mouseY) {
        ItemStack hoveredStack;
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int segments = segToSlot.size();
        int hoveredSeg = RadialOverlay.getHoveredIndex(centerX, centerY, mouseX, mouseY, segments);
        int hoveredResult = -1;
        boolean hoveredIsPlus = false;
        if (hoveredSeg >= 0 && hoveredSeg < segToSlot.size()) {
            int slot = segToSlot.get(hoveredSeg);
            hoveredIsPlus = canAdd && plusSlot != -1 && slot == plusSlot && ((ItemStack)tools.get(slot)).m_41619_();
            int n = hoveredResult = hoveredIsPlus ? -999 : slot;
        }
        if (segments == 0 && hoveredSeg == -1) {
            return -1;
        }
        float step = (float)(Math.PI * 2 / (double)segments);
        float start = -1.5707964f;
        for (int seg = 0; seg < segments; ++seg) {
            boolean isPlusHere;
            boolean isHovered;
            float ang = start + (float)seg * step;
            int x = centerX + Mth.m_14143_((float)(Mth.m_14089_((float)ang) * 42.0f)) - 8;
            int y = centerY + Mth.m_14143_((float)(Mth.m_14031_((float)ang) * 42.0f)) - 8;
            boolean bl = isHovered = seg == hoveredSeg;
            if (isHovered) {
                guiGraphics.m_280509_(x - 2, y - 2, x + 16 + 2, y + 16 + 2, -2130706433);
            }
            int slot = segToSlot.get(seg);
            boolean bl2 = isPlusHere = canAdd && plusSlot != -1 && slot == plusSlot && ((ItemStack)tools.get(slot)).m_41619_();
            if (isPlusHere) {
                RadialOverlay.renderPlusButton(guiGraphics, font, x, y);
                continue;
            }
            ItemStack stack = (ItemStack)tools.get(slot);
            guiGraphics.m_280480_(stack, x, y);
            guiGraphics.m_280370_(font, stack, x, y);
        }
        if (hoveredIsPlus) {
            guiGraphics.m_280557_(font, (Component)Component.m_237115_((String)"screen.travelertoolbelt.add"), mouseX, mouseY);
        } else if (hoveredResult >= 0 && !(hoveredStack = (ItemStack)tools.get(hoveredResult)).m_41619_()) {
            RadialOverlay.renderCenteredText(guiGraphics, (Component)(handEmpty ? Component.m_237115_((String)"screen.travelertoolbelt.take") : Component.m_237115_((String)"screen.travelertoolbelt.swap")), centerX, centerY);
            if (((Boolean)TravelerToolBeltConfig.CLIENT.showTooltip.get()).booleanValue()) {
                guiGraphics.m_280153_(font, hoveredStack, mouseX, mouseY);
            } else {
                guiGraphics.m_280557_(font, hoveredStack.m_41786_(), mouseX, mouseY);
            }
        }
        return hoveredResult;
    }

    public static int renderRadial(GuiGraphics guiGraphics, ItemStack backpack, ItemStack heldItem, NonNullList<ItemStack> tools, boolean canAdd, int centerX, int centerY, int mouseX, int mouseY, float partialTick, float openProgress) {
        drawCrosshair = true;
        if (tools == null) {
            return -1;
        }
        RadialOverlay.beginRadialTransform(guiGraphics, centerX, centerY, openProgress);
        int[] plusSlotRef = new int[1];
        ArrayList<Integer> segToSlot = RadialOverlay.buildSegToSlot(tools, canAdd, plusSlotRef);
        int plusSlot = plusSlotRef[0];
        RadialOverlay.renderRadialBackground(guiGraphics, centerX, centerY);
        int result = RadialOverlay.renderRadialItems(guiGraphics, backpack, tools, canAdd, heldItem.m_41619_(), segToSlot, plusSlot, centerX, centerY, mouseX, mouseY);
        RadialOverlay.endRadialTransform(guiGraphics);
        return result;
    }

    public static int getHoveredIndex(int cx, int cy, int mx, int my, int segments) {
        if (segments == 0) {
            return -1;
        }
        int dx = mx - cx;
        int dy = my - cy;
        if (dx * dx + dy * dy < 900) {
            return -1;
        }
        double ang = Math.atan2(dy, dx);
        ang = RadialOverlay.normalize0To2Pi(ang);
        double start = 4.71238898038469;
        double rel = RadialOverlay.normalize0To2Pi(ang - start);
        double step = Math.PI * 2 / (double)segments;
        int idx = (int)Math.floor((rel + step / 2.0) / step);
        idx = (idx % segments + segments) % segments;
        return idx;
    }

    private static void renderCenteredText(GuiGraphics guiGraphics, Component text, int centerX, int centerY) {
        drawCrosshair = false;
        Font textRenderer = Minecraft.m_91087_().f_91062_;
        int textWidth = textRenderer.m_92852_((FormattedText)text);
        Objects.requireNonNull(textRenderer);
        int textHeight = 9;
        int textX = centerX - textWidth / 2;
        int textY = centerY - textHeight / 2;
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, text, textX, textY, 0xFFFFFF, true);
    }

    private static void renderPlusButton(GuiGraphics guiGraphics, Font font, int x, int y) {
        String plus = "+";
        float s = 1.25f;
        float px = (float)x + 8.0f - (float)font.m_92895_(plus) / 2.0f;
        float f = (float)y + 8.0f;
        Objects.requireNonNull(font);
        float py = f - 9.0f / 2.0f;
        float cx = (float)x + 8.0f;
        float cy = (float)y + 8.0f;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(cx, cy, 0.0f);
        guiGraphics.m_280168_().m_85841_(s, s, 1.0f);
        guiGraphics.m_280168_().m_252880_(-cx, -cy, 0.0f);
        font.m_272078_(plus, px + 0.5f, py + 1.0f, 0xFFFFFF, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0, font.m_92718_());
        guiGraphics.m_280168_().m_85849_();
    }

    private static double normalize0To2Pi(double a) {
        double twoPi = Math.PI * 2;
        if ((a %= twoPi) < 0.0) {
            a += twoPi;
        }
        return a;
    }
}

