/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.handlers;

import com.mojang.blaze3d.platform.InputConstants;
import com.tiviacz.travelertoolbelt.client.model.BeltLayer;
import com.tiviacz.travelertoolbelt.client.model.BeltModel;
import com.tiviacz.travelertoolbelt.client.screens.tooltip.BeltTooltipComponent;
import com.tiviacz.travelertoolbelt.client.screens.tooltip.ClientBeltTooltipComponent;
import com.tiviacz.travelertoolbelt.init.ModItems;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="travelertoolbelt", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModClientEventHandler {
    private static final String CATEGORY = "key.travelertoolbelt.category";
    public static final KeyMapping OPEN_TOOLBELT = new KeyMapping("key.travelertoolbelt.open_toolbelt", InputConstants.Type.KEYSYM, 82, "key.travelertoolbelt.category");
    public static ModelLayerLocation BELT_LAYER = new ModelLayerLocation(new ResourceLocation("travelertoolbelt", "belt"), "main");

    @SubscribeEvent
    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(OPEN_TOOLBELT);
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BELT_LAYER, BeltModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(BeltTooltipComponent.class, ClientBeltTooltipComponent::new);
    }

    @SubscribeEvent
    public static void addItemsToCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(ModItems.BELT);
            event.accept(ModItems.COPPER_BELT);
            event.accept(ModItems.IRON_BELT);
            event.accept(ModItems.GOLD_BELT);
            event.accept(ModItems.DIAMOND_BELT);
            event.accept(ModItems.NETHERITE_BELT);
        }
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers evt) {
        ModClientEventHandler.addPlayerLayer(evt, "default");
        ModClientEventHandler.addPlayerLayer(evt, "slim");
    }

    private static void addPlayerLayer(EntityRenderersEvent.AddLayers evt, String model) {
        LivingEntityRenderer renderer = evt.getSkin(model);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = renderer;
            livingRenderer.m_115326_(new BeltLayer(livingRenderer));
        }
    }
}

