/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.item;

import com.tiviacz.travelertoolbelt.ToolBeltHelper;
import com.tiviacz.travelertoolbelt.client.model.BeltLayer;
import com.tiviacz.travelertoolbelt.client.screens.tooltip.BeltTooltipComponent;
import com.tiviacz.travelertoolbelt.handlers.ForgeClientEventHandler;
import com.tiviacz.travelertoolbelt.handlers.ModClientEventHandler;
import com.tiviacz.travelertoolbelt.toolbelt.ToolBeltWrapper;
import com.tiviacz.travelertoolbelt.util.InventoryHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolBeltItem
extends Item {
    private final int slotCount;
    private final int type;

    public ToolBeltItem(Item.Properties properties, int type, int slotCount) {
        super(properties.m_41487_(1));
        this.type = type;
        this.slotCount = slotCount;
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    public ResourceLocation getModelTexture() {
        return switch (this.type) {
            case 1 -> BeltLayer.COPPER_BELT;
            case 2 -> BeltLayer.IRON_BELT;
            case 3 -> BeltLayer.GOLD_BELT;
            case 4 -> BeltLayer.DIAMOND_BELT;
            case 5 -> BeltLayer.NETHERITE_BELT;
            default -> BeltLayer.LEATHER_BELT;
        };
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.travelertoolbelt.size", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.getSlotCount())).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GOLD));
        if (ForgeClientEventHandler.isShiftPressed()) {
            tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.travelertoolbelt.open_toolbelt_hint", (Object[])new Object[]{Component.m_237113_((String)ModClientEventHandler.OPEN_TOOLBELT.getKey().m_84875_().getString()).m_130940_(ChatFormatting.GRAY)}));
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.travelertoolbelt.add_items_hint"));
            return;
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.travelertoolbelt.more_info").m_130940_(ChatFormatting.GRAY));
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (!slot.m_5857_(stack) || action != ClickAction.SECONDARY) {
            return super.m_142305_(stack, other, slot, action, player, access);
        }
        if (other.m_41619_()) {
            ItemStack extracted = InventoryHelper.extractFromBackpack(ToolBeltWrapper.fromStack(stack).getBeltContents(), 64, false);
            if (!extracted.m_41619_()) {
                this.playInsertSound((Entity)player);
                access.m_142104_(extracted);
                return true;
            }
        } else if (slot.m_150651_(player)) {
            int i = ToolBeltItem.add(player, stack, other, false);
            if (i > 0) {
                this.playInsertSound((Entity)player);
                other.m_41774_(i);
            }
            return true;
        }
        return super.m_142305_(stack, other, slot, action, player, access);
    }

    private static int add(Player player, ItemStack toolbeltStack, ItemStack insertedStack, boolean simulate) {
        int k = insertedStack.m_41613_();
        if (!insertedStack.m_41619_() && ToolBeltHelper.isItemValid(insertedStack)) {
            ToolBeltWrapper wrapper = ToolBeltWrapper.fromStack(toolbeltStack);
            ItemStack result = InventoryHelper.addItemStackToHandler(wrapper.getBeltContents(), insertedStack, simulate);
            return k - result.m_41613_();
        }
        return 0;
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(new BeltTooltipComponent(stack));
    }

    public static boolean isCreative(Player player) {
        return player.m_9236_().m_5776_() && player.f_36096_ instanceof CreativeModeInventoryScreen.ItemPickerMenu;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                if (cap == ForgeCapabilities.ITEM_HANDLER) {
                    ToolBeltWrapper wrapper = ToolBeltWrapper.fromStack(stack);
                    return LazyOptional.of(wrapper::getBeltContents).cast();
                }
                return LazyOptional.empty();
            }
        };
    }
}

