/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.tiviacz.travelertoolbelt.init.ModRecipeSerializers;
import com.tiviacz.travelertoolbelt.item.ToolBeltItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ShapedBeltRecipe
implements CraftingRecipe {
    final int width;
    final int height;
    final NonNullList<Ingredient> recipeItems;
    public final ItemStack result;
    private final ResourceLocation id;
    final String group;
    final CraftingBookCategory category;
    final boolean showNotification;

    public ShapedBeltRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result, boolean showNotification) {
        this.id = id;
        this.group = group;
        this.category = category;
        this.width = width;
        this.height = height;
        this.recipeItems = recipeItems;
        this.result = result;
        this.showNotification = showNotification;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.BELT_SHAPED.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public CraftingBookCategory m_245232_() {
        return this.category;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public boolean m_271738_() {
        return this.showNotification;
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public boolean matches(CraftingContainer inv, Level level) {
        for (int i = 0; i <= inv.m_39347_() - this.width; ++i) {
            for (int j = 0; j <= inv.m_39346_() - this.height; ++j) {
                if (this.matches(inv, i, j, true)) {
                    return true;
                }
                if (!this.matches(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer craftingInventory, int width, int height, boolean mirrored) {
        for (int i = 0; i < craftingInventory.m_39347_(); ++i) {
            for (int j = 0; j < craftingInventory.m_39346_(); ++j) {
                int k = i - width;
                int l = j - height;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = mirrored ? (Ingredient)this.recipeItems.get(this.width - k - 1 + l * this.width) : (Ingredient)this.recipeItems.get(k + l * this.width);
                }
                if (ingredient.test(craftingInventory.m_8020_(i + j * craftingInventory.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer pInput, RegistryAccess pRegistries) {
        ItemStack output = this.m_8043_(pRegistries).m_41777_();
        if (!output.m_41619_()) {
            for (int i = 0; i < pInput.m_6643_(); ++i) {
                ItemStack ingredient = pInput.m_8020_(i);
                if (!(ingredient.m_41720_() instanceof ToolBeltItem)) continue;
                output.m_41751_(ingredient.m_41784_());
                break;
            }
        }
        return output;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    static NonNullList<Ingredient> dissolvePattern(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonNullList = NonNullList.m_122780_((int)(patternWidth * patternHeight), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String string = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                nonNullList.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + String.valueOf(set));
        }
        return nonNullList;
    }

    @VisibleForTesting
    static String[] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < toShrink.length; ++m) {
            String string = toShrink[m];
            i = Math.min(i, ShapedBeltRecipe.firstNonSpace(string));
            int n = ShapedBeltRecipe.lastNonSpace(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] strings = new String[toShrink.length - l - k];
        for (int o = 0; o < strings.length; ++o) {
            strings[o] = toShrink[o + k].substring(i, j + 1);
        }
        return strings;
    }

    public boolean m_142505_() {
        NonNullList<Ingredient> nonNullList = this.m_7527_();
        return nonNullList.isEmpty() || nonNullList.stream().filter(ingredient -> !ingredient.m_43947_()).anyMatch(ingredient -> ingredient.m_43908_().length == 0);
    }

    private static int firstNonSpace(String entry) {
        int i;
        for (i = 0; i < entry.length() && entry.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String entry) {
        int i;
        for (i = entry.length() - 1; i >= 0 && entry.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] patternFromJson(JsonArray patternArray) {
        String[] strings = new String[patternArray.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = GsonHelper.m_13805_((JsonElement)patternArray.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        return strings;
    }

    static Map<String, Ingredient> keyFromJson(JsonObject keyEntry) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : keyEntry.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_288218_((JsonElement)((JsonElement)entry.getValue()), (boolean)false));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static ItemStack itemStackFromJson(JsonObject stackObject) {
        Item item = ShapedBeltRecipe.itemFromJson(stackObject);
        if (stackObject.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = GsonHelper.m_13824_((JsonObject)stackObject, (String)"count", (int)1);
        if (i < 1) {
            throw new JsonSyntaxException("Invalid output count: " + i);
        }
        return new ItemStack((ItemLike)item, i);
    }

    public static Item itemFromJson(JsonObject itemObject) {
        String string = GsonHelper.m_13906_((JsonObject)itemObject, (String)"item");
        Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(ResourceLocation.m_135820_((String)string)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + string + "'"));
        if (item == Items.f_41852_) {
            throw new JsonSyntaxException("Empty ingredient not allowed here");
        }
        return item;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedBeltRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public ShapedBeltRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String string = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Map<String, Ingredient> map = ShapedBeltRecipe.keyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] strings = ShapedBeltRecipe.shrink(ShapedBeltRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int i = strings[0].length();
            int j = strings.length;
            NonNullList<Ingredient> nonNullList = ShapedBeltRecipe.dissolvePattern(strings, map, i, j);
            ItemStack itemStack = ShapedBeltRecipe.itemStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            boolean bl = GsonHelper.m_13855_((JsonObject)json, (String)"show_notification", (boolean)true);
            return new ShapedBeltRecipe(recipeId, string, craftingBookCategory, i, j, nonNullList, itemStack, bl);
        }

        public ShapedBeltRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            int j = buffer.m_130242_();
            String string = buffer.m_130277_();
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            NonNullList nonNullList = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            for (int k = 0; k < nonNullList.size(); ++k) {
                nonNullList.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack itemStack = buffer.m_130267_();
            boolean bl = buffer.readBoolean();
            return new ShapedBeltRecipe(recipeId, string, craftingBookCategory, i, j, (NonNullList<Ingredient>)nonNullList, itemStack, bl);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedBeltRecipe recipe) {
            buffer.m_130130_(recipe.width);
            buffer.m_130130_(recipe.height);
            buffer.m_130070_(recipe.group);
            buffer.m_130068_((Enum)recipe.category);
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.result);
            buffer.writeBoolean(recipe.showNotification);
        }
    }
}

