/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.toolbelt;

import com.tiviacz.travelertoolbelt.ToolBeltHelper;
import com.tiviacz.travelertoolbelt.item.ToolBeltItem;
import com.tiviacz.travelertoolbelt.util.NbtHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class ToolBeltWrapper {
    private final ItemStackHandler contents;
    private final ItemStack toolbelt;

    public ToolBeltWrapper(ItemStack toolbelt) {
        this.toolbelt = toolbelt;
        int storageSlots = ((ToolBeltItem)toolbelt.m_41720_()).getSlotCount();
        this.contents = this.createHandler(storageSlots);
        this.loadBeltContents();
    }

    public static ToolBeltWrapper fromStack(ItemStack stack) {
        return new ToolBeltWrapper(stack);
    }

    public int getBeltCapacity() {
        return ((ToolBeltItem)this.toolbelt.m_41720_()).getSlotCount();
    }

    public ItemStackHandler getBeltContents() {
        return this.contents;
    }

    public void loadBeltContents() {
        if (NbtHelper.has(this.toolbelt, "BeltContainer")) {
            CompoundTag contents = NbtHelper.getHandlerNbt(this.toolbelt, "BeltContainer");
            if (contents.m_128441_("Size") && contents.m_128451_("Size") < this.getBeltCapacity()) {
                contents = this.expandContents(contents, this.getBeltCapacity(), this.toolbelt, "BeltContainer");
            }
            this.contents.deserializeNBT(contents);
        }
    }

    public CompoundTag expandContents(CompoundTag contents, int size, ItemStack backpack, String type) {
        if (contents.m_128451_("Size") < size) {
            NonNullList stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
            ListTag tagList = contents.m_128437_("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag itemTags = tagList.m_128728_(i);
                int slot = itemTags.m_128451_("Slot");
                if (slot < 0 || slot >= stacks.size()) continue;
                stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
            }
            CompoundTag expandedContents = NbtHelper.serializeHandler(new ItemStackHandler(stacks));
            backpack.m_41784_().m_128365_(type, (Tag)expandedContents);
            return expandedContents;
        }
        return contents;
    }

    public void setSlotChanged(int index, ItemStack stack) {
        NbtHelper.update(this.toolbelt, "BeltContainer", this.contents.getSlots(), index, stack);
    }

    private ItemStackHandler createHandler(int size) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                ToolBeltWrapper.this.setSlotChanged(slot, this.getStackInSlot(slot));
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return ToolBeltHelper.isItemValid(stack);
            }
        };
    }
}

