/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.util;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class NbtHelper {
    public static void set(ItemStack stack, String key, Object value) {
        if (key.equals("BeltContainer")) {
            stack.m_41784_().m_128365_(key, (Tag)NbtHelper.serializeHandler((ItemStackHandler)value));
        }
    }

    public static <T> T getOrDefault(ItemStack stack, String key, T defaultValue) {
        if (NbtHelper.has(stack, key) && key.equals("BeltContainer")) {
            return (T)NbtHelper.deserializeHandler(stack, key);
        }
        return defaultValue;
    }

    @Nullable
    public static <T> T get(ItemStack stack, String key) {
        if (NbtHelper.has(stack, key) && key.equals("BeltContainer")) {
            return (T)NbtHelper.deserializeHandler(stack, key);
        }
        return null;
    }

    public static boolean has(ItemStack stack, String key) {
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128441_(key);
        }
        return false;
    }

    public static CompoundTag serializeHandler(ItemStackHandler handler) {
        return NbtHelper.serializeNBT(handler);
    }

    public static CompoundTag serializeNBT(ItemStackHandler handler) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < handler.getSlots(); ++i) {
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            handler.getStackInSlot(i).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128405_("Size", nbtTagList.size());
        return nbt;
    }

    public static CompoundTag getHandlerNbt(ItemStack stack, String key) {
        return stack.m_41783_().m_128469_(key);
    }

    public static NonNullList<ItemStack> deserializeHandler(ItemStack stack, String key) {
        ListTag tagList = stack.m_41783_().m_128469_(key).m_128437_("Items", 10);
        int size = stack.m_41783_().m_128441_("Size") ? stack.m_41783_().m_128469_(key).m_128451_("Size") : tagList.size();
        NonNullList stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= stacks.size()) continue;
            stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
        }
        return stacks;
    }

    public static void update(ItemStack dataStack, String key, int defaultSize, int slot, ItemStack stack) {
        if (dataStack.m_41782_() && dataStack.m_41783_().m_128441_(key)) {
            CompoundTag unboxed = dataStack.m_41783_().m_128469_(key);
            ListTag itemsListed = unboxed.m_128437_("Items", 10);
            CompoundTag newItemTag = new CompoundTag();
            newItemTag.m_128405_("Slot", slot);
            stack.m_41739_(newItemTag);
            if (slot >= 0 && slot < itemsListed.size()) {
                itemsListed.set(slot, (Tag)newItemTag);
            }
        } else {
            ListTag nbtTagList = new ListTag();
            for (int i = 0; i < defaultSize; ++i) {
                CompoundTag itemTag = new CompoundTag();
                itemTag.m_128405_("Slot", i);
                ItemStack.f_41583_.m_41777_().m_41739_(itemTag);
                nbtTagList.add((Object)itemTag);
            }
            CompoundTag newItemTag = new CompoundTag();
            newItemTag.m_128405_("Slot", slot);
            stack.m_41739_(newItemTag);
            if (slot >= 0 && slot < nbtTagList.size()) {
                nbtTagList.set(slot, (Tag)newItemTag);
            }
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("Items", (Tag)nbtTagList);
            nbt.m_128405_("Size", nbtTagList.size());
            dataStack.m_41784_().m_128365_(key, (Tag)nbt);
        }
    }
}

