/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.tiviacz.travelertoolbelt.init.ModRecipeSerializers;
import com.tiviacz.travelertoolbelt.item.ToolBeltItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3955;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_8566;

public class ShapedBeltRecipe
implements class_3955 {
    final int width;
    final int height;
    final class_2371<class_1856> recipeItems;
    public final class_1799 result;
    private final class_2960 id;
    final String group;
    final class_7710 category;
    final boolean showNotification;

    public ShapedBeltRecipe(class_2960 id, String group, class_7710 category, int width, int height, class_2371<class_1856> recipeItems, class_1799 result, boolean showNotification) {
        this.id = id;
        this.group = group;
        this.category = category;
        this.width = width;
        this.height = height;
        this.recipeItems = recipeItems;
        this.result = result;
        this.showNotification = showNotification;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return ModRecipeSerializers.BELT_SHAPED;
    }

    public String method_8112() {
        return this.group;
    }

    public class_7710 method_45441() {
        return this.category;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.result;
    }

    public class_2371<class_1856> method_8117() {
        return this.recipeItems;
    }

    public boolean method_49188() {
        return this.showNotification;
    }

    public boolean method_8113(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public boolean matches(class_8566 inv, class_1937 level) {
        for (int i = 0; i <= inv.method_17398() - this.width; ++i) {
            for (int j = 0; j <= inv.method_17397() - this.height; ++j) {
                if (this.matches(inv, i, j, true)) {
                    return true;
                }
                if (!this.matches(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(class_8566 craftingInventory, int width, int height, boolean mirrored) {
        for (int i = 0; i < craftingInventory.method_17398(); ++i) {
            for (int j = 0; j < craftingInventory.method_17397(); ++j) {
                int k = i - width;
                int l = j - height;
                class_1856 ingredient = class_1856.field_9017;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = mirrored ? (class_1856)this.recipeItems.get(this.width - k - 1 + l * this.width) : (class_1856)this.recipeItems.get(k + l * this.width);
                }
                if (ingredient.method_8093(craftingInventory.method_5438(i + j * craftingInventory.method_17398()))) continue;
                return false;
            }
        }
        return true;
    }

    public class_1799 assemble(class_8566 pInput, class_5455 pRegistries) {
        class_1799 output = this.method_8110(pRegistries).method_7972();
        if (!output.method_7960()) {
            for (int i = 0; i < pInput.method_5439(); ++i) {
                class_1799 ingredient = pInput.method_5438(i);
                if (!(ingredient.method_7909() instanceof ToolBeltItem)) continue;
                output.method_7980(ingredient.method_7948());
                break;
            }
        }
        return output;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    static class_2371<class_1856> dissolvePattern(String[] pattern, Map<String, class_1856> keys, int patternWidth, int patternHeight) {
        class_2371 nonNullList = class_2371.method_10213((int)(patternWidth * patternHeight), (Object)class_1856.field_9017);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String string = pattern[i].substring(j, j + 1);
                class_1856 ingredient = keys.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                nonNullList.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + String.valueOf(set));
        }
        return nonNullList;
    }

    @VisibleForTesting
    static String[] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < toShrink.length; ++m) {
            String string = toShrink[m];
            i = Math.min(i, ShapedBeltRecipe.firstNonSpace(string));
            int n = ShapedBeltRecipe.lastNonSpace(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] strings = new String[toShrink.length - l - k];
        for (int o = 0; o < strings.length; ++o) {
            strings[o] = toShrink[o + k].substring(i, j + 1);
        }
        return strings;
    }

    public boolean method_31584() {
        class_2371<class_1856> nonNullList = this.method_8117();
        return nonNullList.isEmpty() || nonNullList.stream().filter(ingredient -> !ingredient.method_8103()).anyMatch(ingredient -> ingredient.method_8105().length == 0);
    }

    private static int firstNonSpace(String entry) {
        int i;
        for (i = 0; i < entry.length() && entry.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String entry) {
        int i;
        for (i = entry.length() - 1; i >= 0 && entry.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] patternFromJson(JsonArray patternArray) {
        String[] strings = new String[patternArray.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = class_3518.method_15287((JsonElement)patternArray.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        return strings;
    }

    static Map<String, class_1856> keyFromJson(JsonObject keyEntry) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : keyEntry.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), class_1856.method_8102((JsonElement)((JsonElement)entry.getValue()), (boolean)false));
        }
        map.put(" ", class_1856.field_9017);
        return map;
    }

    public static class_1799 itemStackFromJson(JsonObject stackObject) {
        class_1792 item = ShapedBeltRecipe.itemFromJson(stackObject);
        if (stackObject.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = class_3518.method_15282((JsonObject)stackObject, (String)"count", (int)1);
        if (i < 1) {
            throw new JsonSyntaxException("Invalid output count: " + i);
        }
        return new class_1799((class_1935)item, i);
    }

    public static class_1792 itemFromJson(JsonObject itemObject) {
        String string = class_3518.method_15265((JsonObject)itemObject, (String)"item");
        class_1792 item = (class_1792)class_7923.field_41178.method_17966(class_2960.method_12829((String)string)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + string + "'"));
        if (item == class_1802.field_8162) {
            throw new JsonSyntaxException("Empty ingredient not allowed here");
        }
        return item;
    }

    public static class Serializer
    implements class_1865<ShapedBeltRecipe> {
        public ShapedBeltRecipe fromJson(class_2960 recipeId, JsonObject json) {
            String string = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_7710 craftingBookCategory = (class_7710)class_7710.field_40252.method_47920(class_3518.method_15253((JsonObject)json, (String)"category", null), (Enum)class_7710.field_40251);
            Map<String, class_1856> map = ShapedBeltRecipe.keyFromJson(class_3518.method_15296((JsonObject)json, (String)"key"));
            String[] strings = ShapedBeltRecipe.shrink(ShapedBeltRecipe.patternFromJson(class_3518.method_15261((JsonObject)json, (String)"pattern")));
            int i = strings[0].length();
            int j = strings.length;
            class_2371<class_1856> nonNullList = ShapedBeltRecipe.dissolvePattern(strings, map, i, j);
            class_1799 itemStack = ShapedBeltRecipe.itemStackFromJson(class_3518.method_15296((JsonObject)json, (String)"result"));
            boolean bl = class_3518.method_15258((JsonObject)json, (String)"show_notification", (boolean)true);
            return new ShapedBeltRecipe(recipeId, string, craftingBookCategory, i, j, nonNullList, itemStack, bl);
        }

        public ShapedBeltRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            int i = buffer.method_10816();
            int j = buffer.method_10816();
            String string = buffer.method_19772();
            class_7710 craftingBookCategory = (class_7710)buffer.method_10818(class_7710.class);
            class_2371 nonNullList = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
            for (int k = 0; k < nonNullList.size(); ++k) {
                nonNullList.set(k, (Object)class_1856.method_8086((class_2540)buffer));
            }
            class_1799 itemStack = buffer.method_10819();
            boolean bl = buffer.readBoolean();
            return new ShapedBeltRecipe(recipeId, string, craftingBookCategory, i, j, (class_2371<class_1856>)nonNullList, itemStack, bl);
        }

        public void toNetwork(class_2540 buffer, ShapedBeltRecipe recipe) {
            buffer.method_10804(recipe.width);
            buffer.method_10804(recipe.height);
            buffer.method_10814(recipe.group);
            buffer.method_10817((Enum)recipe.category);
            for (class_1856 ingredient : recipe.recipeItems) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.result);
            buffer.writeBoolean(recipe.showNotification);
        }
    }
}

