/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tiviacz.travelertoolbelt.init.ModRecipeSerializers;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7710;
import net.minecraft.class_7798;
import net.minecraft.class_7800;
import net.minecraft.class_7923;

public class ShapedBeltRecipeBuilder
extends class_7798
implements class_5797 {
    private final class_7800 category;
    private final class_1792 result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, class_1856> key = Maps.newLinkedHashMap();
    private final class_161.class_162 advancement = class_161.class_162.method_51698();
    private String group;
    private boolean showNotification = true;

    public ShapedBeltRecipeBuilder(class_7800 pCategory, class_1935 pResult, int pCount) {
        this.category = pCategory;
        this.result = pResult.method_8389();
        this.count = pCount;
    }

    public static ShapedBeltRecipeBuilder shaped(class_7800 pCategory, class_1935 pResult) {
        return ShapedBeltRecipeBuilder.shaped(pCategory, pResult, 1);
    }

    public static ShapedBeltRecipeBuilder shaped(class_7800 pCategory, class_1935 pResult, int pCount) {
        return new ShapedBeltRecipeBuilder(pCategory, pResult, pCount);
    }

    public ShapedBeltRecipeBuilder define(Character pSymbol, class_6862<class_1792> pTag) {
        return this.define(pSymbol, class_1856.method_8106(pTag));
    }

    public ShapedBeltRecipeBuilder define(Character pSymbol, class_1935 pItem) {
        return this.define(pSymbol, class_1856.method_8091((class_1935[])new class_1935[]{pItem}));
    }

    public ShapedBeltRecipeBuilder define(Character pSymbol, class_1856 pIngredient) {
        if (this.key.containsKey(pSymbol)) {
            throw new IllegalArgumentException("Symbol '" + pSymbol + "' is already defined!");
        }
        if (pSymbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(pSymbol, pIngredient);
        return this;
    }

    public ShapedBeltRecipeBuilder pattern(String pPattern) {
        if (!this.rows.isEmpty() && pPattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pPattern);
        return this;
    }

    public ShapedBeltRecipeBuilder unlockedBy(String pCriterionName, class_184 pCriterionTrigger) {
        this.advancement.method_709(pCriterionName, pCriterionTrigger);
        return this;
    }

    public ShapedBeltRecipeBuilder group(String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public ShapedBeltRecipeBuilder showNotification(boolean pShowNotification) {
        this.showNotification = pShowNotification;
        return this;
    }

    public class_1792 method_36441() {
        return this.result;
    }

    public void method_17972(Consumer<class_2444> pFinishedRecipeConsumer, class_2960 pRecipeId) {
        this.ensureValid(pRecipeId);
        this.advancement.method_708(field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)pRecipeId)).method_703(class_170.class_171.method_753((class_2960)pRecipeId)).method_704(class_193.field_1257);
        pFinishedRecipeConsumer.accept((class_2444)new Result(pRecipeId, this.result, this.count, this.group == null ? "" : this.group, ShapedBeltRecipeBuilder.method_46202((class_7800)this.category), this.rows, this.key, this.advancement, pRecipeId.method_45138("recipes/" + this.category.method_46203() + "/"), this.showNotification));
    }

    private void ensureValid(class_2960 pId) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + String.valueOf(pId) + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + String.valueOf(pId) + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + String.valueOf(pId));
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + String.valueOf(pId) + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(pId));
        }
    }

    public static class Result
    extends class_7798.class_7799 {
        private final class_2960 id;
        private final class_1792 result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, class_1856> key;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;
        private final boolean showNotification;

        public Result(class_2960 pId, class_1792 pResult, int pCount, String pGroup, class_7710 pCategory, List<String> pPattern, Map<Character, class_1856> pKey, class_161.class_162 pAdvancement, class_2960 pAdvancementId, boolean pShowNotification) {
            super(pCategory);
            this.id = pId;
            this.result = pResult;
            this.count = pCount;
            this.group = pGroup;
            this.pattern = pPattern;
            this.key = pKey;
            this.advancement = pAdvancement;
            this.advancementId = pAdvancementId;
            this.showNotification = pShowNotification;
        }

        public void method_10416(JsonObject pJson) {
            super.method_10416(pJson);
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            pJson.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, class_1856> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().method_8089());
            }
            pJson.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", class_7923.field_41178.method_10221((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            pJson.add("result", (JsonElement)jsonObject);
            pJson.addProperty("show_notification", Boolean.valueOf(this.showNotification));
        }

        public class_1865<?> method_17800() {
            return ModRecipeSerializers.BELT_SHAPED;
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

