/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelertoolbelt.toolbelt;

import com.tiviacz.travelertoolbelt.ToolBeltHelper;
import com.tiviacz.travelertoolbelt.item.ToolBeltItem;
import com.tiviacz.travelertoolbelt.toolbelt.ItemStackHandler;
import com.tiviacz.travelertoolbelt.util.NbtHelper;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class ToolBeltWrapper {
    private final ItemStackHandler contents;
    private final class_1799 toolbelt;

    public ToolBeltWrapper(class_1799 toolbelt) {
        this.toolbelt = toolbelt;
        int storageSlots = ((ToolBeltItem)toolbelt.method_7909()).getSlotCount();
        this.contents = this.createHandler(storageSlots);
        this.loadBeltContents();
    }

    public static ToolBeltWrapper fromStack(class_1799 stack) {
        return new ToolBeltWrapper(stack);
    }

    public int getBeltCapacity() {
        return ((ToolBeltItem)this.toolbelt.method_7909()).getSlotCount();
    }

    public ItemStackHandler getBeltContents() {
        return this.contents;
    }

    public void loadBeltContents() {
        if (NbtHelper.has(this.toolbelt, "BeltContainer")) {
            class_2487 contents = NbtHelper.getHandlerNbt(this.toolbelt, "BeltContainer");
            if (contents.method_10545("Size") && contents.method_10550("Size") < this.getBeltCapacity()) {
                contents = this.expandContents(contents, this.getBeltCapacity(), this.toolbelt, "BeltContainer");
            }
            this.contents.deserializeNBT(contents);
        }
    }

    public class_2487 expandContents(class_2487 contents, int size, class_1799 backpack, String type) {
        if (contents.method_10550("Size") < size) {
            class_2371 stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
            class_2499 tagList = contents.method_10554("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                class_2487 itemTags = tagList.method_10602(i);
                int slot = itemTags.method_10550("Slot");
                if (slot < 0 || slot >= stacks.size()) continue;
                stacks.set(slot, (Object)class_1799.method_7915((class_2487)itemTags));
            }
            class_2487 expandedContents = NbtHelper.serializeHandler(new ItemStackHandler((class_2371<class_1799>)stacks));
            backpack.method_7948().method_10566(type, (class_2520)expandedContents);
            return expandedContents;
        }
        return contents;
    }

    public void setSlotChanged(int index, class_1799 stack) {
        NbtHelper.update(this.toolbelt, "BeltContainer", this.contents.getSlots(), index, stack);
    }

    private ItemStackHandler createHandler(int size) {
        return new ItemStackHandler(size){

            @Override
            protected void onContentsChanged(int slot) {
                ToolBeltWrapper.this.setSlotChanged(slot, this.getStackInSlot(slot));
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                return ToolBeltHelper.isItemValid(stack);
            }
        };
    }
}

