/*
 * Decompiled with CFR 0.152.
 */
package com.og.survivorsarsenal.common.blocks.barricade;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BarricadeBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty DAMAGE = IntegerProperty.m_61631_((String)"damage", (int)0, (int)2);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private static final Map<BlockPos, Integer> PROGRESS = new HashMap<BlockPos, Integer>();
    private static final int MAX_PROGRESS = 60;
    private static final int SCAN_RADIUS = 1;

    public BarricadeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)DAMAGE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, DAMAGE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.m_5940_(state, level, pos, ctx);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, 20);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int damageStage;
        level.m_186460_(pos, (Block)this, 20);
        List zombies = level.m_45976_(Zombie.class, new AABB((double)(pos.m_123341_() - 1), (double)pos.m_123342_(), (double)(pos.m_123343_() - 1), (double)(pos.m_123341_() + 1 + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1 + 1)));
        if (zombies.isEmpty()) {
            return;
        }
        Zombie zombie = (Zombie)zombies.get(0);
        if (!this.isNearestBarricade(level, pos, zombie)) {
            return;
        }
        if (!this.isInFrontOfZombie(zombie, pos)) {
            return;
        }
        int progress = PROGRESS.getOrDefault(pos, 0) + 1;
        PROGRESS.put(pos, progress);
        level.m_5594_(null, pos, SoundEvents.f_12599_, SoundSource.BLOCKS, 0.3f, 0.9f + random.m_188501_() * 0.2f);
        level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        int crack = progress * 10 / 60;
        level.m_6801_(-1, pos, crack);
        if (progress >= 60) {
            level.m_46961_(pos, false);
            PROGRESS.remove(pos);
        }
        int n = progress < 7 ? 0 : (damageStage = progress < 14 ? 1 : 2);
        if ((Integer)state.m_61143_((Property)DAMAGE) != damageStage) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)DAMAGE, (Comparable)Integer.valueOf(damageStage)), 3);
        }
    }

    private boolean isNearestBarricade(ServerLevel level, BlockPos pos, Zombie zombie) {
        double myDist = zombie.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        int radius = 2;
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-radius, -1, -radius), (BlockPos)pos.m_7918_(radius, 1, radius))) {
            double otherDist;
            if (checkPos.equals((Object)pos) || !(level.m_8055_(checkPos).m_60734_() instanceof BarricadeBlock) || !((otherDist = zombie.m_20275_((double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_() + 0.5, (double)checkPos.m_123343_() + 0.5)) < myDist)) continue;
            return false;
        }
        return true;
    }

    private boolean isInFrontOfZombie(Zombie zombie, BlockPos pos) {
        double dz;
        double dx;
        Vec3 toBlock;
        Vec3 look = zombie.m_20154_().m_82541_();
        return look.m_82526_(toBlock = new Vec3(dx = (double)pos.m_123341_() + 0.5 - zombie.m_20185_(), 0.0, dz = (double)pos.m_123343_() + 0.5 - zombie.m_20189_()).m_82541_()) > 0.25;
    }
}

