/*
 * Decompiled with CFR 0.152.
 */
package com.og.survivorsarsenal.common.loot.blockentity;

import com.og.survivorsarsenal.common.loot.block.AbstractCrateBlock;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class CrateBlockEntity
extends RandomizableContainerBlockEntity {
    private UUID searchingPlayer;
    private double startX;
    private double startY;
    private double startZ;
    private boolean searched = false;
    private int searchTicks = 0;
    public static final int SEARCH_TIME = 60;
    private static final int SOUND_INTERVAL = 10;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);

    protected CrateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public UUID getSearchingPlayer() {
        return this.searchingPlayer;
    }

    public void setSearchingPlayer(UUID playerUUID) {
        this.searchingPlayer = playerUUID;
    }

    public boolean isSearched() {
        return this.searched;
    }

    public void setSearched(boolean searched) {
        this.searched = searched;
    }

    public int getSearchTicks() {
        return this.searchTicks;
    }

    public void setSearchTicks(int ticks) {
        this.searchTicks = ticks;
    }

    public double getStartX() {
        return this.startX;
    }

    public void setStartX(double x) {
        this.startX = x;
    }

    public double getStartY() {
        return this.startY;
    }

    public void setStartY(double y) {
        this.startY = y;
    }

    public double getStartZ() {
        return this.startZ;
    }

    public void setStartZ(double z) {
        this.startZ = z;
    }

    public void startSearching(Player player) {
        if (this.searched || this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.searchingPlayer = player.m_20148_();
        this.searchTicks = 60;
        this.startX = player.m_20185_();
        this.startY = player.m_20186_();
        this.startZ = player.m_20189_();
        this.m_6596_();
        this.sync();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CrateBlockEntity crate) {
        double dz;
        double dy;
        if (crate.searchTicks <= 0 || crate.searchingPlayer == null) {
            return;
        }
        Player player = level.m_46003_(crate.searchingPlayer);
        if (player == null) {
            crate.cancelSearch(level, pos, state, null);
            return;
        }
        double dx = player.m_20185_() - crate.startX;
        if (dx * dx + (dy = player.m_20186_() - crate.startY) * dy + (dz = player.m_20189_() - crate.startZ) * dz > 0.01) {
            crate.cancelSearch(level, pos, state, player);
            return;
        }
        --crate.searchTicks;
        if (crate.searchTicks % 10 == 0) {
            level.m_5594_(null, pos, SoundEvents.f_11672_, SoundSource.BLOCKS, 0.6f, 1.2f);
        }
        if (crate.searchTicks <= 0) {
            crate.finishSearch(level, pos, state, player);
        }
    }

    private void finishSearch(Level level, BlockPos pos, BlockState state, Player player) {
        this.searchTicks = 0;
        this.searchingPlayer = null;
        this.searched = true;
        level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)AbstractCrateBlock.SEARCHING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AbstractCrateBlock.OPEN, (Comparable)Boolean.valueOf(true)), 3);
        level.m_5594_(null, pos, SoundEvents.f_184214_, SoundSource.BLOCKS, 1.0f, 0.9f);
        if (player != null) {
            player.m_5893_((MenuProvider)this);
        }
        this.m_6596_();
        this.sync();
    }

    private void cancelSearch(Level level, BlockPos pos, BlockState state, Player player) {
        this.searchTicks = 0;
        this.searchingPlayer = null;
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AbstractCrateBlock.SEARCHING, (Comparable)Boolean.valueOf(false)), 3);
        level.m_5594_(null, pos, SoundEvents.f_11724_, SoundSource.BLOCKS, 0.8f, 0.8f);
        if (player != null) {
            player.m_5661_((Component)Component.m_237113_((String)"Search cancelled").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF5555))), true);
        }
        this.m_6596_();
        this.sync();
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected Component m_6820_() {
        return Component.m_237113_((String)"Supply Loot");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return ChestMenu.m_39237_((int)id, (Inventory)inventory, (Container)this);
    }

    public int m_6643_() {
        return 27;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("Searched", this.searched);
        if (this.searchingPlayer != null) {
            tag.m_128362_("SearchingPlayer", this.searchingPlayer);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.searched = tag.m_128471_("Searched");
        if (tag.m_128403_("SearchingPlayer")) {
            this.searchingPlayer = tag.m_128342_("SearchingPlayer");
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void sync() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }
}

