/*
 * Decompiled with CFR 0.152.
 */
package com.og.survivorsarsenal.common.recipe;

import com.google.gson.JsonObject;
import com.og.survivorsarsenal.registry.ModRecipes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class ScrapRecyclerRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Item input;
    private final ItemStack output;
    private final int cookTime;

    public ScrapRecyclerRecipe(ResourceLocation id, Item input, ItemStack output, int cookTime) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.cookTime = cookTime;
    }

    public boolean m_5818_(Container container, Level level) {
        return container.m_8020_(0).m_150930_(this.input);
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int w, int h) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.TYPE.get();
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public Item getInputItem() {
        return this.input;
    }

    public static class Serializer
    implements RecipeSerializer<ScrapRecyclerRecipe> {
        public ScrapRecyclerRecipe fromJson(ResourceLocation id, JsonObject json) {
            Item input = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"input")));
            ItemStack output = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"output"))), GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1));
            int cookTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookTime", (int)200);
            return new ScrapRecyclerRecipe(id, input, output, cookTime);
        }

        public ScrapRecyclerRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            Item input = (Item)buf.readRegistryIdUnsafe(ForgeRegistries.ITEMS);
            ItemStack output = buf.m_130267_();
            int cookTime = buf.readInt();
            return new ScrapRecyclerRecipe(id, input, output, cookTime);
        }

        public void toNetwork(FriendlyByteBuf buf, ScrapRecyclerRecipe recipe) {
            buf.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (Object)recipe.input);
            buf.m_130055_(recipe.output);
            buf.writeInt(recipe.cookTime);
        }
    }
}

