/*
 * Decompiled with CFR 0.152.
 */
package com.og.survivorsarsenal.common.recipe;

import com.og.survivorsarsenal.common.utilities.item.RepairKitItem;
import com.og.survivorsarsenal.registry.ModRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class WeaponRepairRecipe
extends CustomRecipe {
    public WeaponRepairRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        ItemStack weapon = ItemStack.f_41583_;
        ItemStack kit = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41763_() && (stack.m_204117_(ItemTags.f_271388_) || stack.m_204117_(ItemTags.f_271540_))) {
                if (!weapon.m_41619_()) {
                    return false;
                }
                weapon = stack;
                continue;
            }
            if (stack.m_41720_() instanceof RepairKitItem) {
                if (!kit.m_41619_()) {
                    return false;
                }
                kit = stack;
                continue;
            }
            return false;
        }
        return !weapon.m_41619_() && !kit.m_41619_() && weapon.m_41768_();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof RepairKitItem)) continue;
            RepairKitItem kit = (RepairKitItem)item;
            ItemStack copy = stack.m_41777_();
            copy.m_41721_(copy.m_41773_() + kit.getDurabilityCost());
            if (copy.m_41773_() >= copy.m_41776_()) continue;
            remaining.set(i, (Object)copy);
        }
        return remaining;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        ItemStack weapon = ItemStack.f_41583_;
        RepairKitItem kit = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            RepairKitItem k;
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41763_() && (stack.m_204117_(ItemTags.f_271388_) || stack.m_204117_(ItemTags.f_271540_))) {
                weapon = stack.m_41777_();
                continue;
            }
            Item item = stack.m_41720_();
            if (!(item instanceof RepairKitItem)) continue;
            kit = k = (RepairKitItem)item;
        }
        if (weapon.m_41619_() || kit == null) {
            return ItemStack.f_41583_;
        }
        int max = weapon.m_41776_();
        int repair = (int)((float)max * kit.getRepairPercent());
        weapon.m_41721_(Math.max(0, weapon.m_41773_() - repair));
        return weapon;
    }

    public boolean m_8004_(int w, int h) {
        return w * h >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.WEAPON_REPAIR.get();
    }
}

