/*
 * Decompiled with CFR 0.152.
 */
package com.og.survivorsarsenal.common.recycler;

import com.og.survivorsarsenal.common.recipe.ScrapRecyclerRecipe;
import com.og.survivorsarsenal.common.recycler.ScrapRecyclerBlock;
import com.og.survivorsarsenal.common.recycler.ScrapRecyclerMenu;
import com.og.survivorsarsenal.registry.ModBlockEntities;
import com.og.survivorsarsenal.registry.ModRecipes;
import com.og.survivorsarsenal.registry.ModSounds;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.ItemStackHandler;

public class ScrapRecyclerBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    private final ItemStackHandler items = new ItemStackHandler(3);
    private int burnTime;
    private int burnTimeTotal;
    private int cookTime;
    private int cookTimeTotal;
    private ScrapRecyclerRecipe currentRecipe;
    private final ContainerData data = new SimpleContainerData(4){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ScrapRecyclerBlockEntity.this.burnTime;
                case 1 -> ScrapRecyclerBlockEntity.this.burnTimeTotal;
                case 2 -> ScrapRecyclerBlockEntity.this.cookTime;
                case 3 -> ScrapRecyclerBlockEntity.this.cookTimeTotal;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ScrapRecyclerBlockEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    ScrapRecyclerBlockEntity.this.burnTimeTotal = value;
                    break;
                }
                case 2: {
                    ScrapRecyclerBlockEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    ScrapRecyclerBlockEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private static final int SOUND_INTERVAL = 110;
    private int soundCooldown = 0;

    public ScrapRecyclerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SCRAP_RECYCLER.get(), pos, state);
    }

    private void spawnProcessingParticles(Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.05;
        double z = (double)pos.m_123343_() + 0.5;
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 2, 0.1, 0.05, 0.1, 0.0);
        if (serverLevel.f_46441_.m_188501_() < 0.25f) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y, z, 1, 0.15, 0.05, 0.15, 0.0);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ScrapRecyclerBlockEntity be) {
        boolean burningNow;
        boolean wasBurning = be.burnTime > 0;
        boolean dirty = false;
        if (be.burnTime > 0) {
            --be.burnTime;
        }
        ItemStack fuel = be.items.getStackInSlot(1);
        if (be.burnTime <= 0 && !fuel.m_41619_() && be.hasRecipe()) {
            be.burnTimeTotal = be.burnTime = ForgeHooks.getBurnTime((ItemStack)fuel, null);
            if (be.burnTime > 0) {
                fuel.m_41774_(1);
                dirty = true;
            }
        }
        if (be.burnTime > 0 && be.hasRecipe()) {
            ++be.cookTime;
            if (be.soundCooldown-- <= 0) {
                level.m_5594_(null, pos, (SoundEvent)ModSounds.RECYCLER_LOOP.get(), SoundSource.BLOCKS, 0.8f, 0.95f + level.f_46441_.m_188501_() * 0.1f);
                be.soundCooldown = 110;
            }
            if (!level.f_46443_ && level.f_46441_.m_188503_(5) == 0) {
                be.spawnProcessingParticles(level, pos);
            }
            if (be.cookTime >= be.cookTimeTotal) {
                be.cookTime = 0;
                be.processRecipe();
                dirty = true;
            }
        } else {
            be.cookTime = 0;
            be.soundCooldown = 0;
        }
        boolean bl = burningNow = be.burnTime > 0;
        if (wasBurning != burningNow) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ScrapRecyclerBlock.LIT, (Comparable)Boolean.valueOf(burningNow)), 3);
        }
        if (dirty) {
            be.m_6596_();
        }
    }

    private boolean hasRecipe() {
        if (this.f_58857_ == null) {
            return false;
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipes.TYPE.get(), (Container)new SimpleContainer(new ItemStack[]{this.items.getStackInSlot(0)}), this.f_58857_);
        if (recipe.isPresent()) {
            this.currentRecipe = (ScrapRecyclerRecipe)recipe.get();
            this.cookTimeTotal = this.currentRecipe.getCookTime();
            ItemStack result = this.currentRecipe.m_8043_(this.f_58857_.m_9598_());
            return this.canOutput(result);
        }
        this.currentRecipe = null;
        return false;
    }

    private boolean canOutput(ItemStack result) {
        ItemStack output = this.items.getStackInSlot(2);
        if (output.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_150942_((ItemStack)output, (ItemStack)result)) {
            return false;
        }
        return output.m_41613_() + result.m_41613_() <= output.m_41741_();
    }

    private void processRecipe() {
        if (this.currentRecipe == null || this.f_58857_ == null) {
            return;
        }
        ItemStack input = this.items.getStackInSlot(0);
        ItemStack output = this.items.getStackInSlot(2);
        ItemStack result = this.currentRecipe.m_8043_(this.f_58857_.m_9598_());
        if (output.m_41619_()) {
            this.items.setStackInSlot(2, result.m_41777_());
        } else {
            output.m_41769_(result.m_41613_());
        }
        input.m_41774_(1);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.survivorsarsenal.scrap_recycler");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new ScrapRecyclerMenu(id, inv, this, this.data);
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("Items", (Tag)this.items.serializeNBT());
        tag.m_128405_("BurnTime", this.burnTime);
        tag.m_128405_("BurnTimeTotal", this.burnTimeTotal);
        tag.m_128405_("CookTime", this.cookTime);
        tag.m_128405_("CookTimeTotal", this.cookTimeTotal);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items.deserializeNBT(tag.m_128469_("Items"));
        this.burnTime = tag.m_128451_("BurnTime");
        this.burnTimeTotal = tag.m_128451_("BurnTimeTotal");
        this.cookTime = tag.m_128451_("CookTime");
        this.cookTimeTotal = tag.m_128451_("CookTimeTotal");
    }

    public ItemStackHandler getItems() {
        return this.items;
    }
}

