/*
 * Decompiled with CFR 0.152.
 */
package com.og.survivorsarsenal.common.recycler;

import com.og.survivorsarsenal.common.recipe.ScrapRecyclerRecipe;
import com.og.survivorsarsenal.common.recycler.ScrapRecyclerBlockEntity;
import com.og.survivorsarsenal.registry.ModMenus;
import com.og.survivorsarsenal.registry.ModRecipes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ScrapRecyclerMenu
extends AbstractContainerMenu {
    private final ScrapRecyclerBlockEntity blockEntity;
    private final ContainerData data;
    private final BlockPos blockPos;

    public ScrapRecyclerMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, (ScrapRecyclerBlockEntity)inv.f_35978_.m_9236_().m_7702_(buf.m_130135_()), (ContainerData)new SimpleContainerData(4));
    }

    public ScrapRecyclerMenu(int id, Inventory inv, ScrapRecyclerBlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenus.SCRAP_RECYCLER.get(), id);
        this.blockEntity = blockEntity;
        this.data = data;
        this.blockPos = blockEntity.m_58899_();
        this.m_38884_(data);
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)blockEntity.getItems(), 0, 56, 17){

            public boolean m_5857_(ItemStack stack) {
                return ScrapRecyclerMenu.this.isValidInput(stack);
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)blockEntity.getItems(), 1, 56, 53){

            public boolean m_5857_(ItemStack stack) {
                return ScrapRecyclerMenu.this.isFuel(stack);
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)blockEntity.getItems(), 2, 116, 35){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inv, col, 8 + col * 18, 142));
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack empty = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return empty;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack copy = stack.m_41777_();
        if (index == 2) {
            if (!this.m_38903_(stack, 3, this.f_38839_.size(), true)) {
                return empty;
            }
            slot.m_40234_(stack, copy);
        } else if (index < 3) {
            if (!this.m_38903_(stack, 3, this.f_38839_.size(), false)) {
                return empty;
            }
        } else if (this.isValidInput(stack)) {
            if (!this.m_38903_(stack, 0, 1, false)) {
                return empty;
            }
        } else if (this.isFuel(stack)) {
            if (!this.m_38903_(stack, 1, 2, false)) {
                return empty;
            }
        } else {
            return empty;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return copy;
    }

    private boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
    }

    private boolean isValidInput(ItemStack stack) {
        if (this.blockEntity.m_58904_() == null) {
            return false;
        }
        return this.blockEntity.m_58904_().m_7465_().m_44013_((RecipeType)ModRecipes.TYPE.get()).stream().map(ScrapRecyclerRecipe::getInputItem).anyMatch(item -> stack.m_150930_(item));
    }

    public boolean isBurning() {
        return this.data.m_6413_(0) > 0;
    }

    public int getBurnProgress() {
        int burn = this.data.m_6413_(0);
        int burnTotal = this.data.m_6413_(1);
        if (burnTotal == 0) {
            burnTotal = 200;
        }
        return burn * 14 / burnTotal;
    }

    public int getCookProgress() {
        int cook = this.data.m_6413_(2);
        int cookTotal = this.data.m_6413_(3);
        if (cookTotal == 0) {
            return 0;
        }
        return cook * 24 / cookTotal;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }
}

