/*
 * Decompiled with CFR 0.152.
 */
package com.og.survivorsarsenal.common.utilities.item;

import com.og.survivorsarsenal.common.weapons.SurvivorsItemTier;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class RepairKitItem
extends Item {
    private final float repairPercent;
    private final int durabilityCost;
    private final SurvivorsItemTier itemTier;

    public RepairKitItem(Item.Properties properties, float repairPercent, int durabilityCost, SurvivorsItemTier itemTier) {
        super(properties.m_41487_(1).m_41503_(32));
        this.repairPercent = repairPercent;
        this.durabilityCost = durabilityCost;
        this.itemTier = itemTier;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack kit = player.m_21120_(hand);
        ItemStack target = player.m_21205_();
        if (!target.m_41763_() || !target.m_41768_()) {
            return InteractionResultHolder.m_19098_((Object)kit);
        }
        if (!level.f_46443_) {
            int max = target.m_41776_();
            int repairAmount = (int)((float)max * this.repairPercent);
            target.m_41721_(Math.max(0, target.m_41773_() - repairAmount));
            kit.m_41622_(this.durabilityCost, (LivingEntity)player, p -> p.m_21190_(hand));
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12471_, SoundSource.PLAYERS, 0.9f, 1.0f);
        }
        return InteractionResultHolder.m_19092_((Object)kit, (boolean)level.f_46443_);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        copy.m_41721_(copy.m_41773_() + this.durabilityCost);
        return copy.m_41773_() >= copy.m_41776_() ? ItemStack.f_41583_ : copy;
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.itemTier.getRarity();
    }

    public float getRepairPercent() {
        return this.repairPercent;
    }

    public int getDurabilityCost() {
        return this.durabilityCost;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.survivorsarsenal.repair_kit.desc"));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.survivorsarsenal.repair_kit.use"));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.survivorsarsenal.repair_kit.amount", (Object[])new Object[]{(int)(this.repairPercent * 100.0f)}));
    }
}

