/*
 * Decompiled with CFR 0.152.
 */
package com.og.survivorsarsenal.common.workstation.scrap_bench;

import com.og.survivorsarsenal.common.workstation.scrap_bench.ScrapBenchBlockEntity;
import com.og.survivorsarsenal.common.workstation.scrap_bench.recipe.ScrapBenchRecipe;
import com.og.survivorsarsenal.registry.ModMenus;
import com.og.survivorsarsenal.registry.ModRecipes;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ScrapBenchMenu
extends AbstractContainerMenu {
    private final Inventory playerInventory;
    private final List<ScrapBenchRecipe> recipes;
    private final DataSlot selectedRecipe = DataSlot.m_39401_();
    private final ScrapBenchBlockEntity blockEntity;

    public ScrapBenchMenu(int id, Inventory inventory, ScrapBenchBlockEntity blockEntity) {
        super((MenuType)ModMenus.SCRAP_BENCH.get(), id);
        this.playerInventory = inventory;
        this.blockEntity = blockEntity;
        Level level = inventory.f_35978_.m_9236_();
        this.recipes = level.m_7465_().m_44013_((RecipeType)ModRecipes.SCRAP_BENCH_TYPE.get());
        this.m_38895_(this.selectedRecipe);
        int startX = 8;
        int startY = 101;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inventory, col + row * 9 + 9, startX + col * 18, startY + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inventory, col, startX + col * 18, startY + 58));
        }
    }

    public ScrapBenchRecipe getSelectedRecipe() {
        return this.recipes.isEmpty() ? null : this.recipes.get(this.selectedRecipe.m_6501_());
    }

    public void nextRecipe() {
        if (!this.recipes.isEmpty()) {
            this.selectedRecipe.m_6422_((this.selectedRecipe.m_6501_() + 1) % this.recipes.size());
        }
    }

    public void previousRecipe() {
        if (!this.recipes.isEmpty()) {
            this.selectedRecipe.m_6422_((this.selectedRecipe.m_6501_() - 1 + this.recipes.size()) % this.recipes.size());
        }
    }

    public boolean m_6366_(Player player, int id) {
        if (id == 0) {
            this.previousRecipe();
            return true;
        }
        if (id == 1) {
            this.nextRecipe();
            return true;
        }
        if (id == 2 && this.canAssemble()) {
            this.assemble(player);
            return true;
        }
        return false;
    }

    private boolean canAssemble() {
        ScrapBenchRecipe recipe = this.getSelectedRecipe();
        if (recipe == null) {
            return false;
        }
        for (Ingredient ingredient : recipe.m_7527_()) {
            if (this.hasIngredient(ingredient)) continue;
            return false;
        }
        return true;
    }

    private void assemble(Player player) {
        block0: for (Ingredient ingredient : this.getSelectedRecipe().m_7527_()) {
            for (int i = 0; i < this.playerInventory.m_6643_(); ++i) {
                ItemStack stack = this.playerInventory.m_8020_(i);
                if (!ingredient.test(stack)) continue;
                stack.m_41774_(1);
                continue block0;
            }
        }
        player.m_150109_().m_36054_(this.getSelectedRecipe().m_8043_(null).m_41777_());
    }

    public boolean hasIngredient(Ingredient ingredient) {
        for (int i = 0; i < this.playerInventory.m_6643_(); ++i) {
            if (!ingredient.test(this.playerInventory.m_8020_(i))) continue;
            return true;
        }
        return false;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }
}

