/*
 * Decompiled with CFR 0.152.
 */
package com.og.survivorsarsenal.registry;

import com.og.survivorsarsenal.common.blocks.BarbedWireBlock;
import com.og.survivorsarsenal.common.blocks.StopSignBlock;
import com.og.survivorsarsenal.common.blocks.barricade.BarricadeBlock;
import com.og.survivorsarsenal.common.blocks.item.BarbedWireItem;
import com.og.survivorsarsenal.common.blocks.item.StopSignItem;
import com.og.survivorsarsenal.common.loot.block.CivilCrateBlock;
import com.og.survivorsarsenal.common.loot.block.FridgeBlock;
import com.og.survivorsarsenal.common.loot.block.LockerBlock;
import com.og.survivorsarsenal.common.loot.block.MarketShelfBlock;
import com.og.survivorsarsenal.common.loot.block.MedicinalCrateBlock;
import com.og.survivorsarsenal.common.loot.block.MilitaryCrateBlock;
import com.og.survivorsarsenal.common.loot.block.SupplyCrateBlock;
import com.og.survivorsarsenal.common.loot.block.TrashCanBlock;
import com.og.survivorsarsenal.common.recycler.ScrapRecyclerBlock;
import com.og.survivorsarsenal.common.recycler.ScrapRecyclerBlockItem;
import com.og.survivorsarsenal.common.workstation.scrap_bench.ScrapBenchBlock;
import com.og.survivorsarsenal.registry.ModItems;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"survivorsarsenal");
    public static final RegistryObject<Block> SCRAP_RECYCLER = BLOCKS.register("scrap_recycler", () -> new ScrapRecyclerBlock(ModBlocks.metal().m_60955_()));
    public static final RegistryObject<Item> SCRAP_RECYCLER_ITEM = ModItems.ITEMS.register("scrap_recycler", () -> new ScrapRecyclerBlockItem((Block)SCRAP_RECYCLER.get(), new Item.Properties()));
    public static final RegistryObject<Block> SCRAP_BENCH = BLOCKS.register("scrap_bench", () -> new ScrapBenchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50091_).m_60918_(SoundType.f_56736_).m_60955_()));
    public static final RegistryObject<Item> SCRAP_BENCH_ITEM = ModItems.ITEMS.register("scrap_bench", () -> new BlockItem((Block)SCRAP_BENCH.get(), new Item.Properties()));
    public static final RegistryObject<Block> BARBED_WIRE = BLOCKS.register("barbed_wire", () -> new BarbedWireBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50184_).m_60918_(SoundType.f_56728_).m_60955_()));
    public static final RegistryObject<Block> STOP_SIGN = BLOCKS.register("stop_sign_block", () -> new StopSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50166_).m_60918_(SoundType.f_56743_).m_60955_()));
    public static final RegistryObject<Item> STOP_SIGN_ITEM = ModItems.ITEMS.register("stop_sign_block", () -> new StopSignItem(new Item.Properties()));
    public static final RegistryObject<Item> BARBED_WIRE_ITEM = ModItems.ITEMS.register("barbed_wire", () -> new BarbedWireItem(new Item.Properties()));
    public static final RegistryObject<Block> BARRICADE = ModBlocks.register("barricade", () -> new BarricadeBlock(ModBlocks.wood().m_60955_()));
    public static final RegistryObject<Block> SUPPLY_CRATE = ModBlocks.register("supply_crate", () -> new SupplyCrateBlock(ModBlocks.wood()));
    public static final RegistryObject<Block> MILITARY_CRATE = ModBlocks.register("military_crate", () -> new MilitaryCrateBlock(ModBlocks.metal()));
    public static final RegistryObject<Block> MEDICINAL_CRATE = ModBlocks.register("medicinal_crate", () -> new MedicinalCrateBlock(ModBlocks.wood()));
    public static final RegistryObject<Block> CIVIL_CRATE = ModBlocks.register("civil_crate", () -> new CivilCrateBlock(ModBlocks.soft()));
    public static final RegistryObject<Block> MARKET_SHELF = ModBlocks.register("market_shelf", () -> new MarketShelfBlock(ModBlocks.wood()));
    public static final RegistryObject<Block> LOCKER = ModBlocks.register("locker", () -> new LockerBlock(ModBlocks.metal().m_60955_()));
    public static final RegistryObject<Block> TRASH_CAN = ModBlocks.register("trash_can", () -> new TrashCanBlock(ModBlocks.metal().m_60955_()));
    public static final RegistryObject<Block> FRIDGE = BLOCKS.register("fridge", () -> new FridgeBlock(ModBlocks.metal().m_60955_()));
    public static final RegistryObject<Item> FRIDGE_ITEM = ModItems.ITEMS.register("fridge", () -> new BlockItem((Block)FRIDGE.get(), new Item.Properties().m_41487_(1)));

    private static BlockBehaviour.Properties wood() {
        return BlockBehaviour.Properties.m_284310_().m_60978_(3.0f).m_60918_(SoundType.f_56736_);
    }

    private static BlockBehaviour.Properties metal() {
        return BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_);
    }

    private static BlockBehaviour.Properties soft() {
        return BlockBehaviour.Properties.m_284310_().m_60978_(3.0f).m_60918_(SoundType.f_56745_);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier) {
        RegistryObject block = BLOCKS.register(name, blockSupplier);
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

