/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.utils.Env;
import java.util.HashSet;
import java.util.Optional;
import net.dawson.adorablehamsterpets.ModRegistries;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.block.ModBlockEntities;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.command.ModCommands;
import net.dawson.adorablehamsterpets.component.HamsterShoulderData;
import net.dawson.adorablehamsterpets.component.ModDataComponentTypes;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.AhpRootConfig;
import net.dawson.adorablehamsterpets.config.AhpWorldGenConfig;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.event.AHPCommonEvents;
import net.dawson.adorablehamsterpets.item.ModItemGroups;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.HamsterPlacementUtil;
import net.dawson.adorablehamsterpets.util.ModLootTableModifiers;
import net.dawson.adorablehamsterpets.world.ModSpawnPlacements;
import net.dawson.adorablehamsterpets.world.ModWorldGeneration;
import net.dawson.adorablehamsterpets.world.gen.ModEntitySpawns;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdorableHamsterPets {
    public static final String MOD_ID = "adorablehamsterpets";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"adorablehamsterpets");
    public static AhpRootConfig ROOT_CONFIG;
    public static AhpConfig CONFIG;
    public static AhpWorldGenConfig WORLD_GEN_CONFIG;

    public static void initRegistries() {
        ROOT_CONFIG = Configs.AHP_ROOT;
        CONFIG = Configs.AHP;
        WORLD_GEN_CONFIG = Configs.AHP_WORLDGEN;
        ModEntities.register();
        ModDataComponentTypes.registerDataComponentTypes();
        ModSounds.register();
        ModBlocks.register();
        ModItems.register();
        ModItemGroups.register();
        ModScreenHandlers.register();
        ModCriteria.register();
        ModBlockEntities.register();
        ModParticles.register();
    }

    public static void initCommonSetup() {
        if (System.getProperty("fabric-api.datagen") == null) {
            ModRegistries.registerCompostables();
            ModRegistries.registerDispenserBehaviors();
            ModEntitySpawns.parseConfig();
            ModWorldGeneration.parseConfig();
            ConfigDataCache.parseConfig();
            ModLootTableModifiers.init();
            if (Platform.getEnvironment() == Env.SERVER) {
                ModPackets.registerPayloads();
            }
            ModPackets.registerC2SPackets();
            ModWorldGeneration.registerBiomeModifications();
            AHPCommonEvents.init();
            PlayerEvent.PLAYER_JOIN.register(AdorableHamsterPets::onPlayerJoin);
            PlayerEvent.PLAYER_CLONE.register(AdorableHamsterPets::onPlayerClone);
            PlayerEvent.CHANGE_DIMENSION.register(AdorableHamsterPets::onPlayerChangeDimension);
            CommandRegistrationEvent.EVENT.register(ModCommands::register);
        }
    }

    public static void initAttributes() {
        EntityAttributeRegistry.register(ModEntities.HAMSTER, HamsterEntity::createHamsterAttributes);
    }

    public static void registerSpawnPlacements() {
        ModSpawnPlacements.register(ModEntities.HAMSTER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (type, world, reason, pos, random) -> Animal.checkAnimalSpawnRules((EntityType)type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random) || ModEntitySpawns.VALID_SPAWN_BLOCKS.contains(world.getBlockState(pos.below()).getBlock()));
    }

    private static void onPlayerJoin(ServerPlayer player) {
        if (Configs.AHP.enableAutoGuidebookDelivery) {
            PlayerAdvancements advancementTracker = player.getAdvancements();
            ResourceLocation flagAdvId = ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"technical/has_received_initial_guidebook");
            AdvancementHolder flagAdvancementEntry = player.server.getAdvancements().get(flagAdvId);
            if (flagAdvancementEntry != null) {
                AdvancementProgress flagProgress = advancementTracker.getOrStartProgress(flagAdvancementEntry);
                if (!flagProgress.isDone()) {
                    ItemStack bookStack = new ItemStack((ItemLike)ModItems.HAMSTER_GUIDE_BOOK.get());
                    DataComponentType bookComponent = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"patchouli", (String)"book"));
                    if (bookComponent != null) {
                        bookStack.set(bookComponent, (Object)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"hamster_tips_guide_book"));
                    } else {
                        LOGGER.error("Could not find Patchouli's book component type! Guidebook will not be functional.");
                    }
                    player.getInventory().placeItemBackInInventory(bookStack);
                    for (String criterion : flagAdvancementEntry.value().criteria().keySet()) {
                        advancementTracker.award(flagAdvancementEntry, criterion);
                    }
                    LOGGER.info("Gave 'Hamster Tips' guide book to player {}.", (Object)player.getName().getString());
                }
            } else {
                LOGGER.warn("Could not find flag advancement: {}", (Object)flagAdvId);
            }
        }
        ((PlayerEntityAccessor)player).adorablehamsterpets$syncShoulderData();
        AdorableHamsterPets.replaceOldBooksInInventory((Container)player.getInventory());
        PlayerEntityAccessor accessor = (PlayerEntityAccessor)player;
        accessor.ahp$initGuideBookTracking(accessor.ahp$computeHasGuideBook((Player)player));
    }

    private static void onPlayerChangeDimension(ServerPlayer player, ResourceKey<Level> oldWorld, ResourceKey<Level> newWorld) {
        ((PlayerEntityAccessor)player).adorablehamsterpets$syncShoulderData();
    }

    private static void onPlayerClone(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean wasDeath_UNRELIABLE) {
        PlayerEntityAccessor oldPlayerAccessor = (PlayerEntityAccessor)oldPlayer;
        PlayerEntityAccessor newPlayerAccessor = (PlayerEntityAccessor)newPlayer;
        if (Configs.AHP.keepHamstersOnShoulderOnDeath) {
            newPlayerAccessor.adorablehamsterpets$getMountOrderQueue().addAll(oldPlayerAccessor.adorablehamsterpets$getMountOrderQueue());
            for (ShoulderLocation location : ShoulderLocation.values()) {
                CompoundTag shoulderNbt = oldPlayerAccessor.getShoulderHamster(location);
                if (shoulderNbt.isEmpty()) continue;
                newPlayerAccessor.setShoulderHamster(location, shoulderNbt);
                LOGGER.debug("Player {} respawned with 'Keep on Shoulder' enabled. Transferring {} hamster to new entity.", (Object)newPlayer.getName().getString(), (Object)location);
            }
            return;
        }
        ServerLevel world = oldPlayer.serverLevel();
        BlockPos deathPos = oldPlayer.blockPosition();
        HashSet<BlockPos> occupiedSpawnPositions = new HashSet<BlockPos>();
        for (ShoulderLocation location : ShoulderLocation.values()) {
            CompoundTag modifiedNbt;
            HamsterEntity hamster;
            CompoundTag shoulderNbt = oldPlayerAccessor.getShoulderHamster(location);
            if (shoulderNbt.isEmpty() || (hamster = HamsterEntity.createFromNbt(world, (Player)oldPlayer, modifiedNbt = AdorableHamsterPets.setKnockedOutInNbt(shoulderNbt))) == null) continue;
            Optional<BlockPos> safePosOpt = HamsterPlacementUtil.findSafeSpawnPosition(deathPos, (Level)world, 5, occupiedSpawnPositions, hamster);
            BlockPos finalSpawnPos = safePosOpt.orElse(deathPos);
            occupiedSpawnPositions.add(finalSpawnPos);
            hamster.moveTo((double)finalSpawnPos.getX() + 0.5, finalSpawnPos.getY(), (double)finalSpawnPos.getZ() + 0.5, 0.0f, 0.0f);
            world.addFreshEntityWithPassengers((Entity)hamster);
            float randomYaw = world.random.nextFloat() * 360.0f;
            hamster.setYBodyRot(randomYaw);
            hamster.setYHeadRot(randomYaw);
            LOGGER.debug("Player {} died. Spawning {} hamster at {} in KO state.", new Object[]{oldPlayer.getName().getString(), location, finalSpawnPos});
        }
    }

    private static CompoundTag setKnockedOutInNbt(CompoundTag originalNbt) {
        return HamsterShoulderData.fromNbt(originalNbt).map(data -> {
            int newFlags = data.hamsterFlags() | 0x100;
            HamsterShoulderData knockedOutData = new HamsterShoulderData(data.entityUuid(), data.variantId(), data.health(), data.inventoryNbt(), data.breedingAge(), data.throwCooldownEndTick(), data.greenBeanBuffData(), data.autoEatCooldownTicks(), data.customName(), data.pinkPetalType(), data.animationPersonalityId(), data.seekingBehaviorData(), data.wanderModeData(), newFlags);
            return knockedOutData.toNbt();
        }).orElse(originalNbt);
    }

    public static void replaceOldBooksInInventory(Container inventory) {
        DataComponentType bookComponent = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)"patchouli", (String)"book"));
        if (bookComponent == null) {
            return;
        }
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!stack.is((Item)ModItems.HAMSTER_GUIDE_BOOK.get()) || stack.has(bookComponent)) continue;
            ItemStack newBookStack = new ItemStack((ItemLike)ModItems.HAMSTER_GUIDE_BOOK.get(), stack.getCount());
            newBookStack.set(bookComponent, (Object)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"hamster_tips_guide_book"));
            inventory.setItem(i, newBookStack);
            LOGGER.info("Upgraded an old Hamster Tips Guide Book to the new Patchouli version.");
        }
    }
}

