/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.block.ModBlockEntities;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.block.client.HamsterBedRenderer;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementHudRenderer;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.client.command.ModClientCommands;
import net.dawson.adorablehamsterpets.client.event.AHPClientScreenEvents;
import net.dawson.adorablehamsterpets.client.gui.widgets.AnnouncementIconAnimator;
import net.dawson.adorablehamsterpets.client.option.ModKeyBindings;
import net.dawson.adorablehamsterpets.client.render.LeafJiggleManager;
import net.dawson.adorablehamsterpets.client.sound.HamsterTreeLoopSoundInstance;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.DismountPressType;
import net.dawson.adorablehamsterpets.config.DismountTriggerType;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.client.HamsterRenderer;
import net.dawson.adorablehamsterpets.entity.client.renderer.HamsterTreeSearcherRenderer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.entity.custom.HamsterTreeSearcherEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.networking.payload.DismountHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.HamsterInputPayload;
import net.dawson.adorablehamsterpets.networking.payload.PlayDistantSoundPayload;
import net.dawson.adorablehamsterpets.networking.payload.PlayGuidebookEffectsPayload;
import net.dawson.adorablehamsterpets.networking.payload.RequestHamsterMountPayload;
import net.dawson.adorablehamsterpets.networking.payload.RequestHamsterRidePayload;
import net.dawson.adorablehamsterpets.networking.payload.SpawnBeddingParticlesPayload;
import net.dawson.adorablehamsterpets.networking.payload.ThrowHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.UpdateHamsterRenderStatePayload;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.screen.HamsterInventoryScreen;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ClientParticleManager;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class AdorableHamsterPetsClient {
    private static final Set<Integer> renderedHamsterIdsThisTick = new HashSet<Integer>();
    private static final Set<Integer> renderedHamsterIdsLastTick = new HashSet<Integer>();
    private static int clientSessionTimer = 0;
    private static long lastSneakPressTime = 0L;
    private static boolean isWaitingForSecondSneakPress = false;
    private static boolean hadShoulderHamsterLastTick = false;
    private static int dismountDebounceTicks = 0;
    private static final int DISMOUNT_DEBOUNCE_DEFAULT = 5;
    private static final AnnouncementHudRenderer announcementHudRenderer = new AnnouncementHudRenderer();
    private static List<AnnouncementManager.PendingNotification> pendingNotifications = Collections.emptyList();
    private static int nextRefreshTicks = 6000;
    private static final Map<Integer, HamsterTreeLoopSoundInstance> activeTreeSounds = new HashMap<Integer, HamsterTreeLoopSoundInstance>();
    private static boolean lastJumpDown = false;
    private static boolean lastSprintDown = false;

    public static void init() {
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)ModBlocks.GREEN_BEANS_CROP.get(), (Block)ModBlocks.CUCUMBER_CROP.get(), (Block)ModBlocks.SUNFLOWER_BLOCK.get(), (Block)ModBlocks.WILD_CUCUMBER_BUSH.get(), (Block)ModBlocks.WILD_GREEN_BEAN_BUSH.get(), (Block)ModBlocks.HAMSTER_BED.get()});
        ConfigApiJava.event().onUpdateClient((id, config) -> {
            if (id.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"main"))) {
                ConfigDataCache.parseConfig();
                AdorableHamsterPets.LOGGER.info("Reloaded Adorable Hamster Pets item tag config on client.");
            }
        });
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> -1, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.HAMSTER_SPAWN_EGG.get()});
        ModPackets.registerS2CPackets();
        AHPClientScreenEvents.register();
        ClientTickEvent.CLIENT_POST.register(AdorableHamsterPetsClient::onEndClientTick);
        ClientGuiEvent.RENDER_HUD.register((context, tickCounter) -> announcementHudRenderer.render(context, tickCounter.getGameTimeDeltaPartialTick(true)));
        ClientCommandRegistrationEvent.EVENT.register(ModClientCommands::register);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> {
            clientSessionTimer = 0;
            ClientParticleManager.INSTANCE.clear();
        });
        EntityEvent.ADD.register((entity, world) -> {
            if (world.isClientSide() && entity instanceof HamsterTreeSearcherEntity) {
                HamsterTreeSearcherEntity searcher = (HamsterTreeSearcherEntity)entity;
                Minecraft client = Minecraft.getInstance();
                HamsterTreeLoopSoundInstance existingSound = activeTreeSounds.get(searcher.getId());
                if (existingSound == null || existingSound.isStopped()) {
                    HamsterTreeLoopSoundInstance newSound = new HamsterTreeLoopSoundInstance(searcher);
                    client.getSoundManager().play((SoundInstance)newSound);
                    activeTreeSounds.put(searcher.getId(), newSound);
                }
                LeafJiggleManager.INSTANCE.onSearcherAdded(searcher);
            }
            return EventResult.pass();
        });
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            if (player.level().isClientSide && hand == InteractionHand.MAIN_HAND && entity instanceof HamsterEntity) {
                HamsterEntity hamster = (HamsterEntity)entity;
                if (Configs.AHP.enableShoulderMountKeybind && ModKeyBindings.FORCE_MOUNT_HAMSTER_KEY.isDown() && hamster.isTame() && hamster.isOwnedBy((LivingEntity)player)) {
                    NetworkManager.sendToServer((CustomPacketPayload)new RequestHamsterMountPayload(hamster.getId()));
                    return EventResult.interruptTrue();
                }
                if (((Boolean)Configs.AHP.enableMountableHamsters.get()).booleanValue() && ModKeyBindings.RIDE_HAMSTER_KEY.isDown() && !hamster.hasPassenger((Entity)player)) {
                    NetworkManager.sendToServer((CustomPacketPayload)new RequestHamsterRidePayload(hamster.getId()));
                    return EventResult.interruptTrue();
                }
            }
            return EventResult.pass();
        });
    }

    public static void initBlockEntityRenderers() {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)ModBlockEntities.HAMSTER_BED_BLOCK_ENTITY.get()), HamsterBedRenderer::new);
    }

    public static void initScreenHandlers() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModScreenHandlers.HAMSTER_INVENTORY_SCREEN_HANDLER.get()), HamsterInventoryScreen::new);
    }

    public static void initEntityRenderers() {
        EntityRendererRegistry.register(ModEntities.HAMSTER, HamsterRenderer::new);
        EntityRendererRegistry.register(ModEntities.HAMSTER_TREE_SEARCHER, HamsterTreeSearcherRenderer::new);
    }

    private static void onEndClientTick(Minecraft client) {
        boolean ridingHamster;
        LeafJiggleManager.INSTANCE.clientTick(client);
        boolean isGuiOpen = client.screen != null;
        AnnouncementIconAnimator.INSTANCE.tick(isGuiOpen);
        if (client.level != null && !AnnouncementManager.INSTANCE.isPatchouliStateSynced()) {
            AnnouncementManager.INSTANCE.syncPatchouliReadState();
            if (AnnouncementManager.INSTANCE.isPatchouliStateSynced()) {
                AnnouncementManager.INSTANCE.processDeferredReadMarks();
            }
        }
        if (client.level != null) {
            pendingNotifications = AnnouncementManager.INSTANCE.getPendingNotifications();
        }
        if (--nextRefreshTicks <= 0) {
            nextRefreshTicks = 6000;
            AnnouncementManager.INSTANCE.refreshManifest();
            AdorableHamsterPets.LOGGER.debug("[AHP Client Tick] Triggered periodic manifest refresh.");
        }
        if (client.player == null || client.level == null) {
            renderedHamsterIdsThisTick.clear();
            renderedHamsterIdsLastTick.clear();
            return;
        }
        boolean bl = ridingHamster = client.player != null && client.player.getVehicle() instanceof HamsterEntity;
        if (ridingHamster && ((Boolean)Configs.AHP.enableMountableHamsters.get()).booleanValue()) {
            boolean jumpDown = client.options.keyJump.isDown();
            boolean sprintDown = client.options.keySprint.isDown();
            if (jumpDown != lastJumpDown || sprintDown != lastSprintDown) {
                lastJumpDown = jumpDown;
                lastSprintDown = sprintDown;
                NetworkManager.sendToServer((CustomPacketPayload)new HamsterInputPayload(jumpDown, sprintDown));
                HamsterEntity hamster = (HamsterEntity)client.player.getVehicle();
                hamster.setRiderInput(jumpDown, sprintDown);
            }
        } else if (lastJumpDown || lastSprintDown) {
            lastJumpDown = false;
            lastSprintDown = false;
            NetworkManager.sendToServer((CustomPacketPayload)new HamsterInputPayload(false, false));
        }
        if (ModKeyBindings.THROW_HAMSTER_KEY.consumeClick()) {
            AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
            if (!currentConfig.enableHamsterThrowing) {
                client.player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.throwing_disabled"), true);
            } else {
                boolean lookingAtReachableBlock = client.hitResult != null && client.hitResult.getType() == HitResult.Type.BLOCK;
                boolean hasShoulderHamsterClient = ((PlayerEntityAccessor)client.player).hasAnyShoulderHamster();
                if (!lookingAtReachableBlock && hasShoulderHamsterClient) {
                    NetworkManager.sendToServer((CustomPacketPayload)new ThrowHamsterPayload());
                }
            }
        }
        HashSet<Integer> stoppedRendering = new HashSet<Integer>(renderedHamsterIdsLastTick);
        stoppedRendering.removeAll(renderedHamsterIdsThisTick);
        for (Integer entityId : stoppedRendering) {
            NetworkManager.sendToServer((CustomPacketPayload)new UpdateHamsterRenderStatePayload(entityId, false));
        }
        renderedHamsterIdsLastTick.clear();
        renderedHamsterIdsLastTick.addAll(renderedHamsterIdsThisTick);
        renderedHamsterIdsThisTick.clear();
        AdorableHamsterPetsClient.handleDismountKeyPress(client);
        AdorableHamsterPetsClient.handleGuidebookWarning(client);
        if (client.level != null && !client.isPaused()) {
            ClientParticleManager.INSTANCE.tick((Level)client.level);
        }
    }

    private static void handleGuidebookWarning(Minecraft client) {
        if (client.player == null) {
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        String username = client.player.getGameProfile().getName();
        if (config.playersWhoHaveSeenGuidebookWarning.contains(username)) {
            return;
        }
        int warningTime = (Integer)config.guidebookWarningTimer.get();
        if (clientSessionTimer > warningTime + 145) {
            clientSessionTimer = 0;
        }
        if (++clientSessionTimer == 20 && AdorableHamsterPetsClient.hasGuideBook((Player)client.player)) {
            config.playersWhoHaveSeenGuidebookWarning.add(username);
            config.save();
        }
        if (clientSessionTimer == warningTime) {
            if (!AdorableHamsterPetsClient.hasGuideBook((Player)client.player)) {
                AdorableHamsterPetsClient.sendWarningPart1((Player)client.player);
            } else {
                config.playersWhoHaveSeenGuidebookWarning.add(username);
                config.save();
            }
        }
        if (clientSessionTimer == warningTime + 140) {
            if (!AdorableHamsterPetsClient.hasGuideBook((Player)client.player)) {
                AdorableHamsterPetsClient.sendWarningPart2((Player)client.player);
            }
            if (!config.playersWhoHaveSeenGuidebookWarning.contains(username)) {
                config.playersWhoHaveSeenGuidebookWarning.add(username);
                config.save();
            }
        }
    }

    private static boolean hasGuideBook(Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!stack.is((Item)ModItems.HAMSTER_GUIDE_BOOK.get())) continue;
            return true;
        }
        return false;
    }

    private static void sendWarningPart1(Player player) {
        MutableComponent message = Component.literal((String)"\n").append((Component)Component.translatable((String)"message.adorablehamsterpets.warning.only_once").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})).append("\n\n");
        message.append((Component)Component.translatable((String)"message.adorablehamsterpets.warning.header_prefix").withStyle(ChatFormatting.GOLD)).append((Component)Component.translatable((String)"message.adorablehamsterpets.warning.header_title").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})).append("\n\n");
        int ticks = (Integer)AdorableHamsterPets.CONFIG.guidebookWarningTimer.get();
        int minutes = Math.max(1, ticks / 1200);
        String key = minutes == 1 ? "message.adorablehamsterpets.warning.context.singular" : "message.adorablehamsterpets.warning.context.plural";
        message.append((Component)Component.translatable((String)key, (Object[])new Object[]{minutes}).withStyle(ChatFormatting.GRAY));
        player.displayClientMessage((Component)message, false);
        player.playSound((SoundEvent)ModSounds.HAMSTER_DING.value(), 1.0f, 0.8f);
    }

    private static void sendWarningPart2(Player player) {
        MutableComponent message = Component.literal((String)"\n").append((Component)Component.translatable((String)"message.adorablehamsterpets.warning.oath_label").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).append(" ").append((Component)Component.translatable((String)"message.adorablehamsterpets.warning.oath_text").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC})).append("\n\n");
        message.append((Component)Component.translatable((String)"message.adorablehamsterpets.warning.action_button").setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN).withBold(Boolean.valueOf(true)).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ahp_open_config_screen")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"message.adorablehamsterpets.warning.action_hover"))))).append("\n\n");
        message.append((Component)Component.translatable((String)"message.adorablehamsterpets.warning.crafting_help").withStyle(ChatFormatting.GRAY));
        player.displayClientMessage((Component)message, false);
        player.playSound((SoundEvent)ModSounds.HAMSTER_DING.value(), 1.0f, 1.0f);
    }

    private static void handleDismountKeyPress(Minecraft client) {
        long delayMillis;
        long currentTime;
        boolean wasKeyPressed;
        boolean hasShoulderHamster;
        if (client.player == null || client.level == null) {
            return;
        }
        try {
            hasShoulderHamster = ((PlayerEntityAccessor)client.player).hasAnyShoulderHamster();
        }
        catch (RuntimeException e) {
            hasShoulderHamster = false;
        }
        if (hasShoulderHamster && !hadShoulderHamsterLastTick) {
            KeyMapping vanillaSneak = client.options.keyShift;
            KeyMapping customDismount = ModKeyBindings.DISMOUNT_HAMSTER_KEY;
            if (vanillaSneak != null) {
                vanillaSneak.setDown(false);
                while (vanillaSneak.consumeClick()) {
                }
            }
            if (customDismount != null) {
                customDismount.setDown(false);
                while (customDismount.consumeClick()) {
                }
            }
            dismountDebounceTicks = 5;
            isWaitingForSecondSneakPress = false;
        }
        hadShoulderHamsterLastTick = hasShoulderHamster;
        if (!hasShoulderHamster) {
            isWaitingForSecondSneakPress = false;
            return;
        }
        if (dismountDebounceTicks > 0) {
            --dismountDebounceTicks;
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        KeyMapping keyToListenFor = Configs.AHP.dismountTriggerType == DismountTriggerType.CUSTOM_KEYBIND ? ModKeyBindings.DISMOUNT_HAMSTER_KEY : client.options.keyShift;
        boolean bl = wasKeyPressed = keyToListenFor != null && keyToListenFor.consumeClick();
        if (wasKeyPressed) {
            if (config.dismountPressType.get() == DismountPressType.SINGLE_PRESS) {
                NetworkManager.sendToServer((CustomPacketPayload)new DismountHamsterPayload());
            } else {
                currentTime = System.currentTimeMillis();
                delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L;
                if (isWaitingForSecondSneakPress && currentTime - lastSneakPressTime <= delayMillis) {
                    NetworkManager.sendToServer((CustomPacketPayload)new DismountHamsterPayload());
                    isWaitingForSecondSneakPress = false;
                } else {
                    isWaitingForSecondSneakPress = true;
                    lastSneakPressTime = currentTime;
                }
            }
        }
        if (isWaitingForSecondSneakPress && (currentTime = System.currentTimeMillis()) - lastSneakPressTime > (delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L)) {
            isWaitingForSecondSneakPress = false;
        }
    }

    public static void handleSpawnBeddingParticles(SpawnBeddingParticlesPayload payload) {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        BlockPos spawnPos = payload.pos().relative(payload.direction());
        Vec3 particleCenter = Vec3.atCenterOf((Vec3i)spawnPos);
        SimpleParticleType particleType = ModParticles.getForVariant(payload.variant());
        for (int i = 0; i < 30; ++i) {
            double offsetX = client.level.random.nextGaussian() * 1.2;
            double offsetY = client.level.random.nextGaussian() * 1.2;
            double offsetZ = client.level.random.nextGaussian() * 1.2;
            client.level.addParticle((ParticleOptions)particleType, particleCenter.x + offsetX, particleCenter.y + offsetY, particleCenter.z + offsetZ, 0.0, -1.23E-4, 0.0);
        }
    }

    public static void handlePlayGuidebookEffects(PlayGuidebookEffectsPayload payload) {
        LocalPlayer player;
        Minecraft client = Minecraft.getInstance();
        if (client == null) {
            return;
        }
        if (payload.closeScreen()) {
            client.setScreen(null);
        }
        if ((player = client.player) == null || client.level == null) {
            return;
        }
        player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.guidebook_rediscovered").withStyle(ChatFormatting.GOLD), true);
        client.level.playLocalSound(player.getX(), player.getY(), player.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 0.5f, 1.2f, false);
        client.level.playLocalSound(player.getX(), player.getY(), player.getZ(), SoundEvents.BOOK_PAGE_TURN, SoundSource.PLAYERS, 0.7f, 1.5f, false);
        ParticleEffectsUtil.spawnParticlesOnEntity((Entity)player, ParticleTypes.ENCHANT, 50, 0.6, 1.0, 0.5, 0.0);
        ParticleEffectsUtil.spawnParticlesOnEntity((Entity)player, ParticleTypes.HAPPY_VILLAGER, 20, 1.0, 1.0, 0.5, 0.0);
    }

    public static void handlePlayDistantSound(PlayDistantSoundPayload payload) {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null || client.player == null) {
            return;
        }
        SoundEvent sound = SoundEvent.createVariableRangeEvent((ResourceLocation)payload.soundId());
        client.level.playLocalSound(client.player.getX(), client.player.getY(), client.player.getZ(), sound, SoundSource.NEUTRAL, payload.volume(), payload.pitch(), false);
    }

    public static void onHamsterRendered(int entityId) {
        renderedHamsterIdsThisTick.add(entityId);
    }

    public static List<AnnouncementManager.PendingNotification> getPendingNotifications() {
        return pendingNotifications;
    }
}

