/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.dawson.adorablehamsterpets.advancement.criterion.DispensedHamsterBeddingCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.payload.SpawnBeddingParticlesPayload;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ModRegistries {
    public static void registerCompostables() {
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.GREEN_BEANS.get()), 0.5f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.CUCUMBER.get()), 0.5f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.GREEN_BEAN_SEEDS.get()), 0.25f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.CUCUMBER_SEEDS.get()), 0.25f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.SUNFLOWER_SEEDS.get()), 0.25f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.HAMSTER_BEDDING.get()), 0.75f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.ACORN.get()), 0.3f);
    }

    public static void registerDispenserBehaviors() {
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.HAMSTER_BEDDING.get()), (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource pointer, ItemStack stack) {
                ServerLevel world = pointer.level();
                Direction direction = (Direction)pointer.state().getValue((Property)DispenserBlock.FACING);
                BlockPos pos = pointer.pos();
                List nearbyPlayers = world.getPlayers(p -> p.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) < 4096.0);
                NetworkManager.sendToPlayers((Iterable)nearbyPlayers, (CustomPacketPayload)new SpawnBeddingParticlesPayload(pos, direction, WoodVariant.OAK));
                for (ServerPlayer player : nearbyPlayers) {
                    ((DispensedHamsterBeddingCriterion)((Object)ModCriteria.DISPENSED_HAMSTER_BEDDING.get())).trigger(player);
                }
                SoundEvent rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, world.random);
                if (rustleSound != null) {
                    world.playSound(null, pos, rustleSound, SoundSource.BLOCKS, 0.15f, 1.2f);
                }
                stack.shrink(1);
                this.setSuccess(true);
                return stack;
            }
        });
    }
}

