/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterBedPlacedUpsideDownCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.block.ModBlockEntities;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.component.ModDataComponentTypes;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HamsterBedBlock
extends BaseEntityBlock
implements EntityBlock {
    public static final MapCodec<HamsterBedBlock> CODEC = HamsterBedBlock.simpleCodec(HamsterBedBlock::new);
    public static final BooleanProperty OCCUPIED = BooleanProperty.create((String)"occupied");
    public static final BooleanProperty UPSIDE_DOWN = BooleanProperty.create((String)"upside_down");
    public static final DirectionProperty ORIENTATION = DirectionProperty.create((String)"orientation", dir -> dir.getAxis().isHorizontal());
    public static final EnumProperty<WoodVariant> WOOD_VARIANT = EnumProperty.create((String)"wood_variant", WoodVariant.class);
    private static final VoxelShape SHAPE_NORMAL = Stream.of(Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)14.0, (double)15.0, (double)3.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)2.0, (double)3.0, (double)14.0), Block.box((double)14.0, (double)0.0, (double)2.0, (double)15.0, (double)3.0, (double)14.0)).reduce(Shapes::or).get();
    private static final VoxelShape SHAPE_UPSIDE_DOWN = Stream.of(Block.box((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.box((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)16.0, (double)2.0), Block.box((double)1.0, (double)13.0, (double)14.0, (double)15.0, (double)16.0, (double)15.0), Block.box((double)1.0, (double)13.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0), Block.box((double)14.0, (double)13.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0)).reduce(Shapes::or).get();

    public HamsterBedBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)ORIENTATION, (Comparable)Direction.NORTH)).setValue(WOOD_VARIANT, (Comparable)((Object)WoodVariant.OAK)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? SHAPE_UPSIDE_DOWN : SHAPE_NORMAL;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? SHAPE_UPSIDE_DOWN : SHAPE_NORMAL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HamsterBedBlockEntity(pos, state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean isUpsideDown = ctx.getClickedFace() == Direction.DOWN;
        WoodVariant variant = (WoodVariant)((Object)ctx.getItemInHand().getOrDefault((DataComponentType)ModDataComponentTypes.WOOD_VARIANT.get(), (Object)WoodVariant.OAK));
        BlockPos pos = ctx.getClickedPos();
        long s = pos.asLong() ^ 0x9E3779B97F4A7C15L;
        s ^= s >>> 30;
        s *= -4658895280553007687L;
        s ^= s >>> 27;
        s *= -7723592293110705685L;
        s ^= s >>> 31;
        int idx = (int)(s & 3L);
        Direction direction = Direction.from2DDataValue((int)idx);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(isUpsideDown))).setValue((Property)ORIENTATION, (Comparable)direction)).setValue(WOOD_VARIANT, (Comparable)((Object)variant));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!world.isClientSide) {
            HamsterBedBlockEntity bedEntity;
            BlockEntity be = world.getBlockEntity(pos);
            if (be instanceof HamsterBedBlockEntity) {
                bedEntity = (HamsterBedBlockEntity)be;
                if (((Boolean)state.getValue((Property)UPSIDE_DOWN)).booleanValue()) {
                    bedEntity.setAllowSleep(false);
                    if (placer instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)placer;
                        ((HamsterBedPlacedUpsideDownCriterion)((Object)ModCriteria.HAMSTER_BED_PLACED_UPSIDE_DOWN.get())).trigger(serverPlayer);
                    }
                }
            }
            if (be instanceof HamsterBedBlockEntity) {
                bedEntity = (HamsterBedBlockEntity)be;
                bedEntity.triggerAnim("hamster_bed_controller", "anim_bed_being_placed");
                UUID hamsterUuid = (UUID)itemStack.get((DataComponentType)ModDataComponentTypes.LINKED_HAMSTER_UUID.get());
                Component hamsterName = (Component)itemStack.get((DataComponentType)ModDataComponentTypes.LINKED_HAMSTER_NAME.get());
                WanderDistance wanderDistance = (WanderDistance)((Object)itemStack.get((DataComponentType)ModDataComponentTypes.WANDER_DISTANCE.get()));
                if (hamsterUuid != null) {
                    bedEntity.setLinkedHamster(hamsterUuid, hamsterName, wanderDistance);
                    Entity entity = ((ServerLevel)world).getEntity(hamsterUuid);
                    if (entity instanceof HamsterEntity) {
                        HamsterEntity hamster = (HamsterEntity)entity;
                        hamster.setLinkedBedPos(Optional.of(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos)));
                        hamster.setWanderModeActive(true);
                    }
                }
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            ItemStack heldStack = player.getItemInHand(player.getUsedItemHand());
            boolean isLureItem = ConfigDataCache.isLureItem(heldStack);
            boolean isAvoidanceItem = ConfigDataCache.isBedAvoidanceFood(heldStack);
            boolean isTributeItem = ConfigDataCache.isResurrectionTribute(heldStack);
            return isLureItem || isAvoidanceItem || isTributeItem ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof HamsterBedBlockEntity) {
            HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
            if (((Boolean)state.getValue((Property)OCCUPIED)).booleanValue()) {
                bedEntity.triggerAnim("hamster_bed_controller", "anim_bed_interact_occupied");
            } else {
                bedEntity.triggerAnim("hamster_bed_controller", "anim_bed_interact_unoccupied");
            }
            ParticleEffectsUtil.spawnParticles(world, pos, 0.2, ModParticles.getForVariant((WoodVariant)((Object)state.getValue(WOOD_VARIANT))), 30, 0.1, 0.1, 0.1, 0.0);
            SoundEvent rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, world.getRandom());
            if (rustleSound != null) {
                world.playSound(null, pos, rustleSound, SoundSource.BLOCKS, 0.2f, 1.8f);
            }
            ItemStack heldStack = player.getItemInHand(player.getUsedItemHand());
            if (player.isShiftKeyDown() && ConfigDataCache.isBedAvoidanceFood(heldStack)) {
                bedEntity.unlinkHamster(player);
                return InteractionResult.SUCCESS;
            }
            if (ConfigDataCache.isBedAvoidanceFood(heldStack)) {
                if (((Boolean)state.getValue((Property)OCCUPIED)).booleanValue()) {
                    bedEntity.getLinkedHamsterUuid().ifPresent(uuid -> {
                        HamsterEntity hamster;
                        Entity entity = ((ServerLevel)world).getEntity(uuid);
                        if (entity instanceof HamsterEntity && (hamster = (HamsterEntity)entity).isSleeping()) {
                            hamster.wakeUpFromBed(true);
                        }
                    });
                }
                bedEntity.applyRepellentEffect();
                player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.bed_repellent_applied").withStyle(ChatFormatting.RED), true);
                world.playSound(null, pos, SoundEvents.HONEY_BLOCK_SLIDE, SoundSource.BLOCKS, 1.2f, 0.8f);
                ParticleEffectsUtil.spawnParticles(world, pos, 0.7, ParticleTypes.SMOKE, 15, 0.4, 0.3, 0.4, 0.01);
                if (!player.getAbilities().instabuild) {
                    heldStack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (ConfigDataCache.isLureItem(heldStack)) {
                boolean wasRepellentActive;
                if (((Boolean)state.getValue((Property)UPSIDE_DOWN)).booleanValue()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.bed_upside_down_lure_fail").withStyle(ChatFormatting.RED), true);
                    world.playSound(null, pos, SoundEvents.DISPENSER_FAIL, SoundSource.BLOCKS, 0.5f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                boolean bl = wasRepellentActive = !bedEntity.isSleepingAllowed();
                if (wasRepellentActive) {
                    bedEntity.setAllowSleep(true);
                }
                boolean lureWasSuccessful = bedEntity.lureHamsterToBed(player, heldStack);
                if (wasRepellentActive) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.bed_repellent_removed").withStyle(ChatFormatting.WHITE), true);
                } else if (lureWasSuccessful) {
                    bedEntity.getLinkedHamsterName().ifPresent(name -> player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.lure_to_bed_success", (Object[])new Object[]{name}), true));
                }
                if (!player.getAbilities().instabuild && Configs.AHP.consumeLureItem) {
                    heldStack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (ConfigDataCache.isResurrectionTribute(heldStack)) {
                if (!((Boolean)Configs.AHP.enableRespawnInBed.get()).booleanValue()) {
                    bedEntity.triggerFailSound();
                    player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.respawn.disabled_by_config").withStyle(ChatFormatting.RED), true);
                    return InteractionResult.SUCCESS;
                }
                if (!bedEntity.isRespawnEnabled()) {
                    bedEntity.setRespawnEnabled(true);
                    if (!player.getAbilities().instabuild) {
                        heldStack.shrink(1);
                    }
                    world.playSound(null, pos, SoundEvents.RESPAWN_ANCHOR_SET_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (heldStack.is(Items.TOTEM_OF_UNDYING)) {
                        ParticleEffectsUtil.spawnParticles(world, pos, 0.5, ParticleTypes.TOTEM_OF_UNDYING, 50, 0.3, 0.3, 0.3, 0.0);
                    } else {
                        ParticleEffectsUtil.spawnParticles(world, pos, 0.5, ParticleTypes.HAPPY_VILLAGER, 25, 0.3, 0.3, 0.3, 0.0);
                        ItemStack particleStack = heldStack.isEmpty() ? new ItemStack((ItemLike)heldStack.getItem()) : heldStack;
                        ParticleEffectsUtil.spawnParticles(world, pos, 0.5, new ItemParticleOption(ParticleTypes.ITEM, particleStack), 25, 0.2, 0.2, 0.2, 0.0);
                    }
                    player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.respawn.activated").withStyle(ChatFormatting.GREEN), true);
                } else {
                    bedEntity.setRespawnEnabled(false);
                    ItemStack refundStack = new ItemStack((ItemLike)heldStack.getItem());
                    Containers.dropItemStack((Level)world, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 1.0), (double)((double)pos.getZ() + 0.5), (ItemStack)refundStack);
                    world.playSound(null, pos, SoundEvents.BEACON_DEACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.respawn.deactivated").withStyle(ChatFormatting.YELLOW), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.isShiftKeyDown()) {
                bedEntity.cycleWanderDistance(player);
                return InteractionResult.SUCCESS;
            }
            bedEntity.toggleWanderMode(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock()) && !world.isClientSide()) {
            SoundEvent rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, world.getRandom());
            if (rustleSound != null) {
                world.playSound(null, pos, rustleSound, SoundSource.BLOCKS, 0.3f, 1.5f);
            }
            ParticleEffectsUtil.spawnParticles(world, pos, 0.2, ModParticles.getForVariant((WoodVariant)((Object)state.getValue(WOOD_VARIANT))), 30, 0.1, 0.1, 0.1, 0.0);
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof HamsterBedBlockEntity) {
                HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)blockEntity;
                ServerLevel serverWorld = (ServerLevel)world;
                bedEntity.getLinkedHamsterUuid().ifPresent(uuid -> {
                    Entity entity = serverWorld.getEntity(uuid);
                    if (entity instanceof HamsterEntity) {
                        LivingEntity patt0$temp;
                        HamsterEntity hamster = (HamsterEntity)entity;
                        hamster.setWanderModeActive(false);
                        hamster.setLinkedBedPos(Optional.empty());
                        if (hamster.isSleeping()) {
                            hamster.wakeUpFromBed(true);
                        }
                        if ((patt0$temp = hamster.getOwner()) instanceof Player) {
                            Player owner = (Player)patt0$temp;
                            if (Configs.AHP.enableBedBreakMessage) {
                                owner.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.bed_broken").withStyle(ChatFormatting.RED), true);
                            }
                        }
                    }
                });
            }
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        if (world.isClientSide()) {
            return HamsterBedBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.HAMSTER_BED_BLOCK_ENTITY.get()), (world1, pos, state1, be) -> {
                if (((Boolean)state1.getValue((Property)UPSIDE_DOWN)).booleanValue() && world1.random.nextInt(35) == 0) {
                    double x = (double)pos.getX() + world1.random.nextDouble();
                    double y = (double)pos.getY() + 0.6;
                    double z = (double)pos.getZ() + world1.random.nextDouble();
                    world1.addParticle((ParticleOptions)ModParticles.getForVariant((WoodVariant)((Object)((Object)state1.getValue(WOOD_VARIANT)))), x, y, z, 0.0, -1.23E-4, 0.0);
                }
            });
        }
        return HamsterBedBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.HAMSTER_BED_BLOCK_ENTITY.get()), HamsterBedBlockEntity::tick);
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        WoodVariant variant = (WoodVariant)((Object)state.getValue(WOOD_VARIANT));
        Item item = (Item)ModItems.HAMSTER_BED_ITEMS.get((Object)variant).get();
        return new ItemStack((ItemLike)item);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        WoodVariant variant = (WoodVariant)((Object)state.getValue(WOOD_VARIANT));
        Item itemToDrop = (Item)ModItems.HAMSTER_BED_ITEMS.get((Object)variant).get();
        ItemStack stack = new ItemStack((ItemLike)itemToDrop);
        BlockEntity blockEntity = (BlockEntity)builder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof HamsterBedBlockEntity) {
            HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)blockEntity;
            bedEntity.getLinkedHamsterUuid().ifPresent(uuid -> stack.set((DataComponentType)ModDataComponentTypes.LINKED_HAMSTER_UUID.get(), uuid));
            bedEntity.getLinkedHamsterName().ifPresent(name -> stack.set((DataComponentType)ModDataComponentTypes.LINKED_HAMSTER_NAME.get(), name));
            stack.set((DataComponentType)ModDataComponentTypes.WANDER_DISTANCE.get(), (Object)bedEntity.getWanderDistance());
        }
        return List.of(stack);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{OCCUPIED, UPSIDE_DOWN, ORIENTATION, WOOD_VARIANT});
    }
}

