/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.block.custom;

import com.mojang.serialization.MapCodec;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.AhpWorldGenConfig;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.util.ClientParticleManager;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class SunflowerBlock
extends TallFlowerBlock
implements BonemealableBlock {
    public static final MapCodec<SunflowerBlock> CODEC = TallFlowerBlock.simpleCodec(SunflowerBlock::new);
    public static final BooleanProperty HAS_SEEDS = BooleanProperty.create((String)"has_seeds");
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public SunflowerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)HAS_SEEDS, (Comparable)Boolean.valueOf(true))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<TallFlowerBlock> codec() {
        return CODEC;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return state.getValue((Property)HALF) == DoubleBlockHalf.UPPER;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int chance;
        if (state.getValue((Property)HALF) != DoubleBlockHalf.UPPER) {
            return;
        }
        if (!((Boolean)state.getValue((Property)HAS_SEEDS)).booleanValue()) {
            AhpWorldGenConfig config = AdorableHamsterPets.WORLD_GEN_CONFIG;
            double modifier = (Double)config.sunflowerRegrowthModifier.get();
            modifier = Math.max(0.1, modifier);
            int baseRegrowthChanceDenominator = 10;
            int effectiveDenominator = (int)Math.round((double)baseRegrowthChanceDenominator * modifier);
            if (random.nextInt(effectiveDenominator = Math.max(1, effectiveDenominator)) == 0) {
                world.setBlock(pos, (BlockState)state.setValue((Property)HAS_SEEDS, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        if (AdorableHamsterPets.WORLD_GEN_CONFIG.enableGlowingSunflowers && !world.isDay() && !((Boolean)state.getValue((Property)LIT)).booleanValue() && random.nextInt(chance = ((Integer)AdorableHamsterPets.WORLD_GEN_CONFIG.glowingSunflowerChance.get()).intValue()) == 0) {
            world.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
            world.scheduleTick(pos, (Block)this, random.nextIntBetweenInclusive(200, 600));
        }
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && world.isDay()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockState currentState = world.getBlockState(pos);
        if (currentState.is((Block)this) && ((Boolean)currentState.getValue((Property)LIT)).booleanValue()) {
            world.setBlock(pos, (BlockState)currentState.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock()) && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            world.updateNeighborsAt(pos, (Block)this);
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            BlockPos immutablePos = pos.immutable();
            ClientParticleManager.INSTANCE.addOrUpdate(immutablePos, "sunflower_glow_ring", w -> ParticleEffectsUtil.spawnSpinningRing(w, immutablePos, (ParticleOptions)ParticleTypes.WAX_ON, 1, 0.5, 0.65, 0.4, 0.5, 5.0, -0.4), (w, p) -> {
                BlockState current = w.getBlockState(p);
                return current.is((Block)this) && (Boolean)current.getValue((Property)LIT) != false;
            });
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
            BlockPos topPos = pos.above();
            BlockState topState = world.getBlockState(topPos);
            if (topState.is((Block)this) && topState.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
                return this.useWithoutItem(topState, world, topPos, player, hit);
            }
            return InteractionResult.PASS;
        }
        if (((Boolean)state.getValue((Property)HAS_SEEDS)).booleanValue()) {
            if (!world.isClientSide) {
                int seedAmount = world.random.nextInt(3) + 1;
                ItemStack seedStack = new ItemStack((ItemLike)ModItems.SUNFLOWER_SEEDS.get(), seedAmount);
                Containers.dropItemStack((Level)world, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)seedStack);
                world.setBlock(pos, (BlockState)state.setValue((Property)HAS_SEEDS, (Comparable)Boolean.valueOf(false)), 2);
                world.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockPos topPos;
        BlockState topState;
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!world.isClientSide && (topState = world.getBlockState(topPos = pos.above())).is((Block)this) && topState.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            world.setBlock(topPos, (BlockState)topState.setValue((Property)HAS_SEEDS, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack(ModItems.SUNFLOWER_BLOCK_ITEM);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        SunflowerBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack(ModItems.SUNFLOWER_BLOCK_ITEM));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HAS_SEEDS, LIT});
    }
}

