/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.block.custom;

import com.mojang.serialization.MapCodec;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.AhpWorldGenConfig;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WildGreenBeanBushBlock
extends BushBlock {
    public static final MapCodec<WildGreenBeanBushBlock> CODEC = WildGreenBeanBushBlock.simpleCodec(WildGreenBeanBushBlock::new);
    public static final BooleanProperty SEEDED = BooleanProperty.create((String)"seeded");
    private static final VoxelShape SEEDLESS_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape SEEDED_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public WildGreenBeanBushBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SEEDED, (Comparable)Boolean.valueOf(true)));
    }

    public MapCodec<WildGreenBeanBushBlock> codec() {
        return CODEC;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ModItems.GREEN_BEAN_SEEDS.get());
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)SEEDED) != false ? SEEDED_SHAPE : SEEDLESS_SHAPE;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)SEEDED) == false;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)SEEDED)).booleanValue()) {
            AhpWorldGenConfig config = AdorableHamsterPets.WORLD_GEN_CONFIG;
            double modifier = (Double)config.wildBushRegrowthModifier.get();
            modifier = Math.max(0.1, modifier);
            int baseRegrowthChanceDenominator = 5;
            int effectiveDenominator = (int)Math.round((double)baseRegrowthChanceDenominator * modifier);
            effectiveDenominator = Math.max(1, effectiveDenominator);
            if (world.getRawBrightness(pos.above(), 0) >= 9 && random.nextInt(effectiveDenominator) == 0) {
                BlockState newState = (BlockState)state.setValue((Property)SEEDED, (Comparable)Boolean.valueOf(true));
                world.setBlock(pos, newState, 2);
                world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (((Boolean)state.getValue((Property)SEEDED)).booleanValue()) {
            if (!world.isClientSide) {
                int seedAmount = 1 + world.random.nextInt(2);
                WildGreenBeanBushBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.GREEN_BEAN_SEEDS.get(), seedAmount));
                world.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() * 0.4f);
                BlockState newState = (BlockState)state.setValue((Property)SEEDED, (Comparable)Boolean.valueOf(false));
                world.setBlock(pos, newState, 2);
                world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SEEDED});
    }

    protected boolean mayPlaceOn(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.is(Blocks.GRASS_BLOCK) || floor.is(Blocks.DIRT) || floor.is(Blocks.COARSE_DIRT) || floor.is(Blocks.PODZOL) || floor.is(Blocks.FARMLAND) || floor.is(Blocks.CLAY) || floor.is(Blocks.MOSS_BLOCK) || floor.is(Blocks.MUD);
    }
}

