/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.block.entity;

import java.util.Optional;
import java.util.UUID;
import net.dawson.adorablehamsterpets.block.ModBlockEntities;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HamsterBedBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private Optional<UUID> linkedHamsterUuid = Optional.empty();
    private Optional<Component> linkedHamsterName = Optional.empty();
    private WanderDistance wanderDistance = WanderDistance.MEDIUM;
    private boolean isNewlyPlaced = true;
    private boolean allowSleep = true;
    private boolean respawnEnabled = false;
    private int failSoundTimer = 0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "hamster_bed_controller", 5, state -> {
            BlockState blockState = ((HamsterBedBlockEntity)state.getAnimatable()).getBlockState();
            if (((Boolean)blockState.getValue((Property)HamsterBedBlock.OCCUPIED)).booleanValue()) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("anim_bed_idle_waving_occupied"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("anim_bed_idle_waving_unoccupied"));
        });
        controller.triggerableAnim("anim_bed_being_placed", RawAnimation.begin().thenPlay("anim_bed_being_placed"));
        controller.triggerableAnim("anim_bed_becoming_occupied", RawAnimation.begin().thenPlay("anim_bed_becoming_occupied"));
        controller.triggerableAnim("anim_bed_becoming_unoccupied", RawAnimation.begin().thenPlay("anim_bed_becoming_unoccupied"));
        controller.triggerableAnim("anim_bed_interact_occupied", RawAnimation.begin().thenPlay("anim_bed_interact_occupied"));
        controller.triggerableAnim("anim_bed_interact_unoccupied", RawAnimation.begin().thenPlay("anim_bed_interact_unoccupied"));
        registrar.add(controller);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Optional<UUID> getLinkedHamsterUuid() {
        return this.linkedHamsterUuid;
    }

    public Optional<Component> getLinkedHamsterName() {
        return this.linkedHamsterName;
    }

    public boolean isWanderModeActive() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.linkedHamsterUuid.isPresent() && (entity = serverWorld.getEntity(this.linkedHamsterUuid.get())) instanceof HamsterEntity) {
                HamsterEntity hamster = (HamsterEntity)entity;
                return hamster.isWanderModeActive();
            }
        }
        return false;
    }

    public boolean isRespawnEnabled() {
        return this.respawnEnabled;
    }

    public void setRespawnEnabled(boolean enabled) {
        this.respawnEnabled = enabled;
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void triggerFailSound() {
        this.failSoundTimer = 7;
    }

    public boolean isNewlyPlaced() {
        return this.isNewlyPlaced;
    }

    public void markAsUsed() {
        this.isNewlyPlaced = false;
    }

    public boolean isSleepingAllowed() {
        return this.allowSleep;
    }

    public void setAllowSleep(boolean allow) {
        this.allowSleep = allow;
        this.setChanged();
    }

    public void applyRepellentEffect() {
        this.setAllowSleep(false);
    }

    public HamsterBedBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.HAMSTER_BED_BLOCK_ENTITY.get(), pos, state);
    }

    public void setLinkedHamster(UUID uuid, Component name, WanderDistance distance) {
        this.linkedHamsterUuid = Optional.of(uuid);
        this.linkedHamsterName = Optional.of(name);
        this.wanderDistance = distance;
        this.setChanged();
    }

    public WanderDistance getWanderDistance() {
        return this.wanderDistance;
    }

    public void toggleWanderMode(Player player) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.linkedHamsterUuid.isPresent() && (entity = serverWorld.getEntity(this.linkedHamsterUuid.get())) instanceof HamsterEntity) {
                HamsterEntity hamster = (HamsterEntity)entity;
                boolean newMode = !hamster.isWanderModeActive();
                hamster.setWanderModeActive(newMode);
                if (!newMode && ((Boolean)this.getBlockState().getValue((Property)HamsterBedBlock.OCCUPIED)).booleanValue() && hamster.isSleeping()) {
                    hamster.wakeUpFromBed(true);
                }
                MutableComponent status = newMode ? Component.literal((String)"ENABLED") : Component.literal((String)"DISABLED");
                player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.wander_mode_set", (Object[])new Object[]{hamster.getName(), status}), true);
                this.level.playSound(null, this.getBlockPos(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.5f, newMode ? 1.2f : 0.8f);
            }
        }
    }

    public void cycleWanderDistance(Player player) {
        WanderDistance[] values = WanderDistance.values();
        this.wanderDistance = values[(this.wanderDistance.ordinal() + 1) % values.length];
        this.setChanged();
        if (this.linkedHamsterName.isPresent()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.wander_distance_set", (Object[])new Object[]{this.linkedHamsterName.get(), this.wanderDistance.getSerializedName()}), true);
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    public boolean lureHamsterToBed(Player player, ItemStack lureItem) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.linkedHamsterUuid.isPresent() && (entity = serverWorld.getEntity(this.linkedHamsterUuid.get())) instanceof HamsterEntity) {
                HamsterEntity hamster = (HamsterEntity)entity;
                if (!hamster.isWanderModeActive()) {
                    hamster.setWanderModeActive(true);
                }
                if (hamster.isOrderedToSit() || hamster.isSleeping()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.lure_to_bed_fail").withStyle(ChatFormatting.RED), true);
                    return false;
                }
                hamster.lureToBed();
                SoundEvent lureSound = ModSounds.getDynamicItemSound(lureItem);
                this.level.playSound(null, this.getBlockPos(), lureSound, SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleEffectsUtil.spawnParticles(this.level, this.getBlockPos(), 0.7, new ItemParticleOption(ParticleTypes.ITEM, lureItem), 8, 0.25, 0.25, 0.25, 0.05);
                return true;
            }
        }
        return false;
    }

    public void unlinkHamster(Player player) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.linkedHamsterUuid.isPresent()) {
                HamsterEntity hamster;
                Entity entity;
                UUID uuidToUnlink = this.linkedHamsterUuid.get();
                Component hamsterNameToUnlink = this.linkedHamsterName.orElse((Component)Component.literal((String)"A hamster"));
                if (((Boolean)this.getBlockState().getValue((Property)HamsterBedBlock.OCCUPIED)).booleanValue() && (entity = serverWorld.getEntity(uuidToUnlink)) instanceof HamsterEntity && (hamster = (HamsterEntity)entity).isSleeping()) {
                    hamster.wakeUpFromBed(true);
                }
                this.linkedHamsterUuid = Optional.empty();
                this.linkedHamsterName = Optional.empty();
                this.wanderDistance = (WanderDistance)((Object)Configs.AHP.defaultWanderDistance.get());
                this.setChanged();
                entity = serverWorld.getEntity(uuidToUnlink);
                if (entity instanceof HamsterEntity) {
                    hamster = (HamsterEntity)entity;
                    hamster.setWanderModeActive(false);
                    hamster.setLinkedBedPos(Optional.empty());
                }
                player.displayClientMessage((Component)Component.translatable((String)"message.adorablehamsterpets.bed_unlinked", (Object[])new Object[]{hamsterNameToUnlink}).withStyle(ChatFormatting.YELLOW), true);
                this.level.playSound(null, this.getBlockPos(), SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.2f);
            }
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.linkedHamsterUuid.ifPresent(uuid -> nbt.putUUID("LinkedHamsterUuid", uuid));
        this.linkedHamsterName.ifPresent(name -> nbt.putString("LinkedHamsterName", Component.Serializer.toJson((Component)name, (HolderLookup.Provider)registryLookup)));
        nbt.putString("WanderDistance", this.wanderDistance.getSerializedName());
        nbt.putBoolean("IsNewlyPlaced", this.isNewlyPlaced);
        nbt.putBoolean("RespawnEnabled", this.respawnEnabled);
        nbt.putBoolean("AllowSleep", this.allowSleep);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.linkedHamsterUuid = nbt.hasUUID("LinkedHamsterUuid") ? Optional.of(nbt.getUUID("LinkedHamsterUuid")) : Optional.empty();
        this.linkedHamsterName = nbt.contains("LinkedHamsterName") ? Optional.ofNullable(Component.Serializer.fromJson((String)nbt.getString("LinkedHamsterName"), (HolderLookup.Provider)registryLookup)) : Optional.empty();
        this.wanderDistance = WanderDistance.valueOf(nbt.getString("WanderDistance").toUpperCase());
        this.isNewlyPlaced = nbt.contains("IsNewlyPlaced") ? nbt.getBoolean("IsNewlyPlaced") : false;
        this.allowSleep = !nbt.contains("AllowSleep") || nbt.getBoolean("AllowSleep");
        this.respawnEnabled = nbt.getBoolean("RespawnEnabled");
        if (this.getBlockState().hasProperty((Property)HamsterBedBlock.UPSIDE_DOWN) && ((Boolean)this.getBlockState().getValue((Property)HamsterBedBlock.UPSIDE_DOWN)).booleanValue()) {
            this.allowSleep = false;
        }
    }

    public static void tick(Level world, BlockPos pos, BlockState state, HamsterBedBlockEntity be) {
        if (be.failSoundTimer > 0) {
            --be.failSoundTimer;
            if (be.failSoundTimer == 6) {
                world.playSound(null, pos, (SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (be.failSoundTimer == 0) {
                world.playSound(null, pos, (SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.BLOCKS, 1.0f, 0.2f);
            }
        }
    }
}

