/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.dawson.adorablehamsterpets.client.announcements.Announcement;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.client.announcements.ClientAnnouncementState;
import net.dawson.adorablehamsterpets.client.announcements.PatchouliIntegration;
import net.dawson.adorablehamsterpets.client.gui.MarkdownRenderer;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.mixin.accessor.ScreenWidgetAdder;
import net.dawson.adorablehamsterpets.mixin.accessor.ValidatedFieldAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class AnnouncementScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"textures/gui/announcement_ui.png");
    private static final ResourceLocation SCROLLBAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"textures/gui/announcement_ui_scroll_bar.png");
    private static final int BACKGROUND_WIDTH = 256;
    private static final int BACKGROUND_HEIGHT = 256;
    private static final int TOTAL_GUI_HEIGHT = 283;
    private static final int CONTENT_X_OFFSET = 17;
    private static final int CONTENT_Y_OFFSET = 35;
    private static final int CONTENT_WIDTH = 221;
    private static final int CONTENT_HEIGHT = 204;
    private static final int SCROLLBAR_X_OFFSET = 242;
    private static final int SCROLLBAR_START_Y = 28;
    private static final int SCROLLBAR_END_Y = 221;
    private static final int EDGE_MARGIN = 7;
    private static final int BUTTON_WIDTH = 100;
    private final Announcement announcement;
    private MarkdownRenderer markdownRenderer;
    private String markdownContent = "Loading...";
    private double scrollY = 0.0;
    private int guiLeft;
    private int guiTop;
    @Nullable
    private Style hoveredStyle = null;
    private final Screen parentScreen;
    private final BookEntry virtualEntry;
    private final String reason;
    private float uiScale = 1.0f;
    private boolean isDraggingScrollbar = false;
    private int scaledBackgroundWidth;
    private int scaledBackgroundHeight;
    private int scaledTotalHeight;
    private int scaledContentXOffset;
    private int scaledContentYOffset;
    private int scaledContentWidth;
    private int scaledContentHeight;
    private int scaledScrollBarXOffset;
    private int scaledScrollBarStartY;
    private int scaledScrollBarEndY;
    private int scaledButtonHeight;
    private int scaledButtonPadding;

    public AnnouncementScreen(Announcement announcement, String reason, @Nullable Screen parentScreen, BookEntry virtualEntry) {
        super((Component)Component.literal((String)announcement.title()));
        this.announcement = announcement;
        this.reason = reason;
        this.parentScreen = parentScreen;
        this.virtualEntry = virtualEntry;
    }

    protected void init() {
        int currentX;
        Button.Builder builder;
        super.init();
        int availableWidth = Math.max(0, this.width - 14);
        int availableHeight = Math.max(0, this.height - 14);
        int buttonRows = 2;
        int unscaledTotalHeight = 283 + (buttonRows - 1) * 27;
        float scaleX = (float)availableWidth / 256.0f;
        float scaleY = (float)availableHeight / (float)unscaledTotalHeight;
        this.uiScale = Math.min(1.0f, Math.min(scaleX, scaleY));
        this.scaledBackgroundWidth = Math.round(256.0f * this.uiScale);
        this.scaledBackgroundHeight = Math.round(256.0f * this.uiScale);
        this.scaledContentXOffset = Math.round(17.0f * this.uiScale);
        this.scaledContentYOffset = Math.round(35.0f * this.uiScale);
        this.scaledContentWidth = Math.max(1, Math.round(221.0f * this.uiScale));
        this.scaledContentHeight = Math.max(1, Math.round(204.0f * this.uiScale));
        this.scaledScrollBarXOffset = Math.round(242.0f * this.uiScale);
        this.scaledScrollBarStartY = Math.round(28.0f * this.uiScale);
        this.scaledScrollBarEndY = Math.round(221.0f * this.uiScale);
        this.scaledButtonHeight = Math.max(12, Math.round(20.0f * this.uiScale));
        this.scaledButtonPadding = Math.max(2, Math.round(7.0f * this.uiScale));
        this.scaledTotalHeight = this.scaledBackgroundHeight + buttonRows * (this.scaledButtonHeight + this.scaledButtonPadding);
        this.guiLeft = 7 + (availableWidth - this.scaledBackgroundWidth) / 2;
        this.guiTop = 7 + (availableHeight - this.scaledTotalHeight) / 2;
        this.markdownRenderer = new MarkdownRenderer(this.markdownContent, this.guiLeft + this.scaledContentXOffset, this.guiTop + this.scaledContentYOffset, this.scaledContentWidth);
        AnnouncementManager.INSTANCE.fetchMarkdown(this.announcement.markdown()).thenAccept(content -> this.minecraft.execute(() -> {
            this.markdownContent = content;
            this.markdownRenderer = new MarkdownRenderer((String)content, this.guiLeft + this.scaledContentXOffset, this.guiTop + this.scaledContentYOffset, this.scaledContentWidth);
        }));
        int closeButtonX = this.guiLeft - 10;
        int closeButtonY = this.guiTop + 5;
        ((ScreenWidgetAdder)((Object)this)).adorablehamsterpets$addWidget(Button.builder((Component)Component.literal((String)"\u2190").withStyle(ChatFormatting.BOLD), button -> this.returnToBook()).bounds(closeButtonX, closeButtonY, 20, 16).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.adorablehamsterpets.announcement.button.close.tooltip"))).build());
        int buttonWidth = 100;
        int buttonPadding = this.scaledButtonPadding;
        ArrayList<Button.Builder> primaryBuilders = new ArrayList<Button.Builder>();
        ArrayList<Button.Builder> secondaryBuilders = new ArrayList<Button.Builder>();
        MutableComponent markAsReadTooltip = Component.translatable((String)"gui.adorablehamsterpets.announcement.button.mark_as_read.tooltip").append("\n\n").append((Component)Component.translatable((String)"gui.adorablehamsterpets.announcement.button.mark_as_read.shift_tooltip").withStyle(ChatFormatting.GOLD));
        primaryBuilders.add(Button.builder((Component)Component.translatable((String)"gui.adorablehamsterpets.announcement.button.mark_as_read"), button -> {
            if (Screen.hasShiftDown()) {
                Book book = (Book)BookRegistry.INSTANCE.books.get(ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)"hamster_tips_guide_book"));
                if (book != null) {
                    AnnouncementManager.INSTANCE.getAllManifestMessages().forEach(msg -> {
                        ResourceLocation entryId;
                        BookEntry entry;
                        AnnouncementManager.INSTANCE.markAsSeen(msg.id());
                        if ("update".equals(msg.kind())) {
                            AnnouncementManager.INSTANCE.setLastAcknowledgedUpdate(msg.semver());
                        }
                        if ((entry = (BookEntry)book.getContents().entries.get(entryId = ResourceLocation.fromNamespaceAndPath((String)"adorablehamsterpets", (String)("announcement_" + msg.id())))) != null) {
                            PatchouliIntegration.setEntryAsRead(entry);
                        }
                    });
                }
            } else {
                PatchouliIntegration.setEntryAsRead(this.virtualEntry);
                AnnouncementManager.INSTANCE.markAsSeen(this.announcement.id());
                if ("update".equals(this.announcement.kind())) {
                    AnnouncementManager.INSTANCE.setLastAcknowledgedUpdate(this.announcement.semver());
                }
            }
            this.returnToBook();
        }).tooltip(Tooltip.create((Component)markAsReadTooltip)));
        primaryBuilders.add(Button.builder((Component)Component.translatable((String)"gui.adorablehamsterpets.announcement.button.disable_icons"), button -> {
            ((ValidatedFieldAccessor)Configs.AHP.enableNotificationIcons).adorablehamsterpets$set(false);
            Configs.AHP.save();
            this.onClose();
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.adorablehamsterpets.announcement.button.disable_icons.tooltip"))));
        MutableComponent remindLaterTooltip = Component.translatable((String)"gui.adorablehamsterpets.announcement.button.snooze_days.tooltip", (Object[])new Object[]{Configs.AHP.snoozeUpdateReminderDays.get()});
        ClientAnnouncementState state = AnnouncementManager.INSTANCE.getClientState();
        Instant snoozeUntil = state.snoozed_ids().get(this.announcement.id());
        if (snoozeUntil != null && snoozeUntil.isAfter(Instant.now())) {
            Duration remaining = Duration.between(Instant.now(), snoozeUntil);
            remindLaterTooltip.append("\n\n").append(this.formatDuration(remaining));
        }
        primaryBuilders.add(Button.builder((Component)Component.translatable((String)"gui.adorablehamsterpets.announcement.button.snooze_days"), button -> {
            AnnouncementManager.INSTANCE.setSnooze(this.announcement.id(), (Integer)Configs.AHP.snoozeUpdateReminderDays.get());
            if (this.parentScreen instanceof TitleScreen) {
                AnnouncementManager.INSTANCE.queueDeferredReadMark(this.virtualEntry.getId());
            } else {
                PatchouliIntegration.setEntryAsRead(this.virtualEntry);
            }
            this.returnToBook();
        }).tooltip(Tooltip.create((Component)remindLaterTooltip)));
        primaryBuilders.add(Button.builder((Component)Component.translatable((String)"gui.adorablehamsterpets.announcement.button.snooze_session"), button -> {
            AnnouncementManager.INSTANCE.snoozeForSession(this.announcement.id());
            if (this.parentScreen instanceof TitleScreen) {
                AnnouncementManager.INSTANCE.queueDeferredReadMark(this.virtualEntry.getId());
            } else {
                PatchouliIntegration.setEntryAsRead(this.virtualEntry);
            }
            this.returnToBook();
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.adorablehamsterpets.announcement.button.snooze_session.tooltip"))));
        if ("update".equals(this.announcement.kind())) {
            String changelogUrl = String.format("https://modrinth.com/mod/adorable-hamster-pets/version/%s-1.21.1+fabric", this.announcement.semver());
            secondaryBuilders.add(Button.builder((Component)Component.translatable((String)"gui.adorablehamsterpets.announcement.button.changelog"), button -> Util.getPlatform().openUri(URI.create(changelogUrl))).tooltip(Tooltip.create((Component)Component.translatable((String)"gui.adorablehamsterpets.announcement.button.changelog.tooltip"))));
        }
        secondaryBuilders.add(Button.builder((Component)Component.translatable((String)"gui.adorablehamsterpets.announcement.button.discord"), button -> Util.getPlatform().openUri(URI.create("https://discord.gg/w54mk5bqdf"))).tooltip(Tooltip.create((Component)Component.translatable((String)"config.adorablehamsterpets.main.helpAndResources.joinDiscord.desc"))));
        int availableWidthButtons = Math.max(0, this.width - 14);
        int primaryCount = primaryBuilders.size();
        int secondaryCount = secondaryBuilders.size();
        int totalPrimaryWidth = primaryCount * buttonWidth + Math.max(0, primaryCount - 1) * buttonPadding;
        int totalSecondaryWidth = secondaryCount * buttonWidth + Math.max(0, secondaryCount - 1) * buttonPadding;
        int startXRow1 = 7 + (availableWidthButtons - totalPrimaryWidth) / 2;
        int startXRow2 = 7 + (availableWidthButtons - totalSecondaryWidth) / 2;
        int firstRowY = this.guiTop + this.scaledBackgroundHeight + this.scaledButtonPadding;
        int secondRowY = firstRowY + this.scaledButtonHeight + this.scaledButtonPadding;
        for (int i = 0; i < primaryCount; ++i) {
            builder = (Button.Builder)primaryBuilders.get(i);
            currentX = startXRow1 + i * (buttonWidth + buttonPadding);
            ((ScreenWidgetAdder)((Object)this)).adorablehamsterpets$addWidget(builder.bounds(currentX, firstRowY, buttonWidth, this.scaledButtonHeight).build());
        }
        for (int j = 0; j < secondaryCount; ++j) {
            builder = (Button.Builder)secondaryBuilders.get(j);
            currentX = startXRow2 + j * (buttonWidth + buttonPadding);
            ((ScreenWidgetAdder)((Object)this)).adorablehamsterpets$addWidget(builder.bounds(currentX, secondRowY, buttonWidth, this.scaledButtonHeight).build());
        }
    }

    private Component formatDuration(Duration duration) {
        String formattedString;
        long days = duration.toDays();
        long hours = duration.toHoursPart();
        long minutes = duration.toMinutesPart();
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        if (days > 0L) {
            parts.add((CallSite)((Object)(days + (days == 1L ? " day" : " days"))));
        }
        if (hours > 0L) {
            parts.add((CallSite)((Object)(hours + (hours == 1L ? " hour" : " hours"))));
        }
        if (days == 0L && minutes > 0L) {
            parts.add((CallSite)((Object)(minutes + (minutes == 1L ? " minute" : " minutes"))));
        }
        if ((formattedString = String.join((CharSequence)", ", parts)).isEmpty()) {
            formattedString = "less than a minute";
        }
        return Component.translatable((String)"tooltip.adorablehamsterpets.hud.snooze_remaining", (Object[])new Object[]{formattedString}).withStyle(ChatFormatting.GRAY);
    }

    private void returnToBook() {
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.parentScreen);
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        Component textAtMouse = this.getTextAt(mouseX, mouseY);
        this.hoveredStyle = textAtMouse != null && textAtMouse.getStyle().getClickEvent() != null ? textAtMouse.getStyle() : null;
        super.render(context, mouseX, mouseY, delta);
        context.enableScissor(this.guiLeft + this.scaledContentXOffset, this.guiTop + this.scaledContentYOffset, this.guiLeft + this.scaledContentXOffset + this.scaledContentWidth, this.guiTop + this.scaledContentYOffset + this.scaledContentHeight);
        this.markdownRenderer.render(context, (int)this.scrollY, this.hoveredStyle);
        context.disableScissor();
        int maxScroll = Math.max(0, this.markdownRenderer.getTotalHeight() - this.scaledContentHeight);
        if (maxScroll > 0) {
            int scrollbarX = this.guiLeft + this.scaledScrollBarXOffset;
            int scrollbarTravel = this.scaledScrollBarEndY - this.scaledScrollBarStartY;
            double scrollPercent = this.scrollY / (double)maxScroll;
            int scrollbarY = this.guiTop + this.scaledScrollBarStartY + (int)(scrollPercent * (double)scrollbarTravel);
            context.blit(SCROLLBAR_TEXTURE, scrollbarX, scrollbarY, 0.0f, 0.0f, 4, 25, 4, 25);
        }
        PoseStack matrices = context.pose();
        matrices.pushPose();
        float defaultScale = 1.3f * this.uiScale;
        int maxWidth = Math.round(222.0f * this.uiScale);
        MutableComponent boldTitle = this.title.copy().withStyle(ChatFormatting.BOLD);
        int titleWidth = Minecraft.getInstance().font.width((FormattedText)boldTitle);
        float finalScale = defaultScale;
        if ((float)titleWidth * defaultScale > (float)maxWidth) {
            finalScale = (float)maxWidth / (float)titleWidth;
        }
        matrices.translate((double)this.width / 2.0, (double)(this.guiTop + Math.round(9.0f * this.uiScale)), 0.0);
        matrices.scale(finalScale, finalScale, 1.0f);
        context.drawString(Minecraft.getInstance().font, (Component)boldTitle, -titleWidth / 2, 0, 0x323232, false);
        matrices.popPose();
    }

    public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.renderBackground(context, mouseX, mouseY, delta);
        context.pose().pushPose();
        context.pose().translate((float)this.guiLeft, (float)this.guiTop, 0.0f);
        context.pose().scale(this.uiScale, this.uiScale, 1.0f);
        context.blit(BACKGROUND_TEXTURE, 0, 0, 0.0f, 0.0f, 256, 256, 256, 256);
        context.pose().popPose();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft != null && this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = Math.max(0, this.markdownRenderer.getTotalHeight() - this.scaledContentHeight);
        double scrollStep = 10.0f * this.uiScale;
        this.scrollY = Mth.clamp((double)(this.scrollY - verticalAmount * scrollStep), (double)0.0, (double)maxScroll);
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            Style style;
            Component clickedText;
            int maxScroll = Math.max(0, this.markdownRenderer.getTotalHeight() - this.scaledContentHeight);
            if (maxScroll > 0) {
                int scrollbarX = this.guiLeft + this.scaledScrollBarXOffset;
                int scrollbarTravel = this.scaledScrollBarEndY - this.scaledScrollBarStartY;
                double scrollPercent = this.scrollY / (double)maxScroll;
                int scrollbarY = this.guiTop + this.scaledScrollBarStartY + (int)(scrollPercent * (double)scrollbarTravel);
                if (mouseX >= (double)scrollbarX && mouseX < (double)(scrollbarX + 4) && mouseY >= (double)scrollbarY && mouseY < (double)(scrollbarY + 25)) {
                    this.isDraggingScrollbar = true;
                    return true;
                }
            }
            if ((clickedText = this.getTextAt(mouseX, mouseY)) != null && this.handleComponentClicked(style = clickedText.getStyle())) {
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingScrollbar) {
            int maxScroll = Math.max(0, this.markdownRenderer.getTotalHeight() - this.scaledContentHeight);
            int scrollbarTravel = this.scaledScrollBarEndY - this.scaledScrollBarStartY;
            double relativeMouseY = mouseY - (double)(this.guiTop + this.scaledScrollBarStartY);
            double scrollPercent = relativeMouseY / (double)scrollbarTravel;
            this.scrollY = Mth.clamp((double)(scrollPercent * (double)maxScroll), (double)0.0, (double)maxScroll);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDraggingScrollbar = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void onClose() {
        this.returnToBook();
    }

    @Nullable
    public Component getTextAt(double x, double y) {
        int scrollOffset = (int)((double)(this.guiTop + this.scaledContentYOffset) - this.scrollY);
        int relativeY = (int)y - scrollOffset;
        if (relativeY < 0) {
            return null;
        }
        int currentY = 0;
        for (String originalLine : this.markdownRenderer.lines) {
            MutableComponent styledText;
            int indentationLevel;
            int lineHeight;
            boolean isListItem;
            String trimmedLine = originalLine.trim();
            int startX = this.guiLeft + this.scaledContentXOffset;
            int contentWidth = this.markdownRenderer.width;
            String content = trimmedLine;
            boolean bl = isListItem = trimmedLine.startsWith("- ") || trimmedLine.startsWith("* ") || trimmedLine.matches("^\\d+\\.\\s.*");
            if (trimmedLine.isEmpty()) {
                Objects.requireNonNull(this.font);
                lineHeight = 9 / 2;
            } else if (trimmedLine.startsWith("#")) {
                int level;
                for (level = 0; level < trimmedLine.length() && trimmedLine.charAt(level) == '#'; ++level) {
                }
                String text = trimmedLine.substring(level).trim();
                float scale = Math.max(1.0f, 2.0f - (float)(level - 1) * 0.25f);
                int scaledWidth = (int)((float)this.markdownRenderer.width / scale);
                MutableComponent styledText2 = Component.literal((String)text).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
                List wrappedLines = Minecraft.getInstance().font.split((FormattedText)styledText2, scaledWidth);
                int n = wrappedLines.size();
                Objects.requireNonNull(this.font);
                int heightOfLines = n * (int)(9.0f * scale);
                int totalSpacing = Math.max(0, wrappedLines.size() - 1) * 2;
                lineHeight = heightOfLines + totalSpacing + 4;
            } else if (trimmedLine.equals("---")) {
                lineHeight = 13;
            } else {
                indentationLevel = MarkdownRenderer.getIndentationLevel(originalLine);
                if (isListItem) {
                    contentWidth = this.markdownRenderer.width - (indentationLevel + 1) * 10;
                    startX += indentationLevel * 10 + 10;
                    content = trimmedLine.matches("^\\d+\\.\\s.*") ? trimmedLine.substring(trimmedLine.indexOf(46) + 1).trim() : trimmedLine.substring(1).trim();
                } else {
                    contentWidth = this.markdownRenderer.width - indentationLevel * 10;
                    startX += indentationLevel * 10;
                    content = originalLine.substring(indentationLevel * 4);
                }
                styledText = this.markdownRenderer.parseLineToText(content, null);
                List wrappedLines = this.font.split((FormattedText)styledText, contentWidth);
                int n = wrappedLines.size();
                Objects.requireNonNull(this.font);
                lineHeight = n * (9 + 2);
            }
            if (relativeY >= currentY && relativeY < currentY + lineHeight) {
                if (!(trimmedLine.isEmpty() || trimmedLine.startsWith("#") || trimmedLine.equals("---"))) {
                    indentationLevel = MarkdownRenderer.getIndentationLevel(originalLine);
                    contentWidth = isListItem ? this.markdownRenderer.width - (indentationLevel + 1) * 10 : this.markdownRenderer.width - indentationLevel * 10;
                    styledText = this.markdownRenderer.parseLineToText(content, null);
                    List wrappedLines = this.font.split((FormattedText)styledText, contentWidth);
                    int yInBlock = relativeY - currentY;
                    Objects.requireNonNull(this.font);
                    int lineIndex = yInBlock / (9 + 2);
                    if (lineIndex >= 0 && lineIndex < wrappedLines.size()) {
                        FormattedCharSequence orderedText = (FormattedCharSequence)wrappedLines.get(lineIndex);
                        int relativeX = (int)x - startX;
                        Style style = this.minecraft.font.getSplitter().componentStyleAtWidth(orderedText, relativeX);
                        if (style != null && style.getClickEvent() != null) {
                            return Component.literal((String)"").setStyle(style);
                        }
                    }
                }
                return null;
            }
            currentY += lineHeight;
        }
        return null;
    }
}

